/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateDefinitionsContext;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDefinitionsHandler
extends OCClassActionHandlerBase<OCMembersContainer, OCFunctionSymbol, OCGenerateDefinitionsContext> {
    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateDefinitionsContext context, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        List<OCGenerateUtil.Replacement> replacements = editor != null && OCCppDefinitionsUtil.shouldInline(editor, file2, context.getParent()) ? OCCppDefinitionsUtil.getInlineReplacements(file2, chosenCandidates) : (editor != null ? OCCppDefinitionsUtil.getOutsideReplacementsAtCaretPosition(file2, editor, chosenCandidates, null) : OCCppDefinitionsUtil.getOutsideReplacementsAtPreferredPosition(file2, chosenCandidates));
        OCGenerateUtil.applyReplacements(project2, this.getActionName(), replacements);
    }

    @Override
    @NotNull
    protected List<OCGenerateDefinitionsContext> getContexts(@NotNull Project project2, final @Nullable Editor editor, final @NotNull PsiFile psiFile) {
        OCFile file2 = (OCFile)psiFile;
        final PsiElement context = OCGenerateUtil.getElementAt(editor, psiFile);
        OCStructLike struct = (OCStructLike)PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCUnion.class});
        List<OCNamespaceSymbol> parents = new ArrayList<OCNamespaceLikeSymbol>();
        if (struct != null) {
            OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
            if (symbol != null && !symbol.isPredeclaration()) {
                parents.add(symbol);
            }
        } else {
            OCCppNamespace namespace;
            CommonProcessors.CollectProcessor<OCNamespaceSymbol> collector = new CommonProcessors.CollectProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    OCSymbolKind kind = symbol.getKind();
                    return (kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION || kind == OCSymbolKind.NAMESPACE) && !symbol.isPredeclaration();
                }
            };
            OCCommonProcessors.TypeFilteredProcessor processor2 = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)collector, OCNamespaceSymbol.class);
            file2.processSymbolsRecursively(processor2);
            OCFile header = null;
            if (!file2.isHeader() && (header = file2.getAssociatedFile()) != null) {
                header.processSymbolsRecursively(processor2);
            }
            OCNamespaceSymbol namespaceSymbol = (namespace = (OCCppNamespace)PsiTreeUtil.getParentOfType((PsiElement)context, OCCppNamespace.class)) != null ? (OCNamespaceSymbol)namespace.getSymbol() : null;
            block0: for (OCNamespaceSymbol parent : collector.getResults()) {
                if (namespaceSymbol == null) {
                    parents.add(parent);
                    continue;
                }
                OCNamespaceSymbol ancestor = parent;
                while (true) {
                    if (namespaceSymbol.isSameSymbol(ancestor)) {
                        parents.add(parent);
                        continue block0;
                    }
                    OCSymbolWithQualifiedName ancestorParent = ancestor.getParent();
                    if (!(ancestorParent instanceof OCNamespaceSymbol)) continue block0;
                    ancestor = (OCNamespaceSymbol)ancestorParent;
                }
            }
            if (namespaceSymbol == null) {
                if (header != null) {
                    parents.add((OCNamespaceSymbol)header.getMembersContainer(false));
                } else {
                    parents.add((OCNamespaceSymbol)file2.getMembersContainer(false));
                }
            }
            parents = ContainerUtil.filter(parents, (Condition)new Condition<OCMembersContainer>(){

                public boolean value(OCMembersContainer container) {
                    OCGenerateDefinitionsContext actionContext = OCGenerateDefinitionsHandler.this.evaluateActionContext(container, context);
                    return actionContext != null && (!actionContext.getMemberCandidates().isEmpty() || OCGenerateDefinitionsHandler.this.allowEmptySelection(actionContext));
                }
            });
        }
        return ContainerUtil.map(parents, (Function)new Function<OCMembersContainer, OCGenerateDefinitionsContext>(){

            public OCGenerateDefinitionsContext fun(OCMembersContainer p) {
                return OCGenerateDefinitionsHandler.this.evaluateActionContext(p, OCGenerateUtil.getElementAt(editor, psiFile));
            }
        });
    }

    @Override
    @Nullable
    protected OCGenerateDefinitionsContext evaluateActionContext(OCMembersContainer parent, PsiElement element) {
        return new OCGenerateDefinitionsContext(parent, element);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return OCCodeInsightUtil.isValid((PsiElement)file2);
    }

    @Override
    @NotNull
    public String getActionName() {
        return OCBundle.message("generate.definitions.action.name", new Object[0]);
    }

    @Override
    protected String getActionTitle() {
        return OCBundle.message("generate.definitions.action.title", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("generate.definitions.action.memberChooserTitle", new Object[0]);
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateDefinitionsContext context) {
        return OCBundle.message("generate.definitions.action.noMembers", context.getParentNameUppercase());
    }

    @Override
    protected String getNoParentsMessage() {
        return OCBundle.message("generate.definitions.action.noParent", new Object[0]);
    }

    @Override
    protected String getParentChooserTitle() {
        return "Choose Class/Namespace";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }
}

