/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCEnumComboOption;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateCopyHandler
extends OCGenerateMethodHandler {
    protected static final OCEnumComboOption<DepthMode> DEPTH_MODE = new OCEnumComboOption<DepthMode>("Depth", (T[])DepthMode.values(), "deep", "shallow");

    @Override
    protected String getActionTitle() {
        return "Generate -copyWithZone:";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"copyWithZone:"};
    }

    @Override
    @Nullable
    protected String getParentProtocol() {
        return "NSCopying";
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateMethodActionContext context) {
        ArrayList<Pair<OCOption, Object>> list = new ArrayList<Pair<OCOption, Object>>();
        list.add(new Pair(DEPTH_MODE, (Object)(settings != null && settings.COPY_IS_DEEP ? DepthMode.DEEP : DepthMode.SHALLOW)));
        list.add(new Pair((Object)DECLARE_IN_INTERFACE, (Object)(settings == null || settings.DECLARE_GENERATED_METHODS ? 1 : 0)));
        return list;
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        settings.COPY_IS_DEEP = OCGenerateCopyHandler.getOption(optionValues, DEPTH_MODE) == DepthMode.DEEP;
        settings.DECLARE_GENERATED_METHODS = OCGenerateCopyHandler.getOption(optionValues, DECLARE_IN_INTERFACE);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol classSymbol;
        if (element instanceof OCInterface) {
            return OCCallableUtil.methodSignature(actionContext.getBaseMethod(), element) + ";";
        }
        ArrayList<String> strings = new ArrayList<String>();
        DepthMode depthMode = (DepthMode)((Object)this.getOption(actionContext, DEPTH_MODE));
        StringBuilder body = new StringBuilder();
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty();
            OCType type = ivar.getType().resolve(element.getContainingFile(), true);
            if (property != null && !property.isReadonly()) {
                DepthMode propertyDepthMode = property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY) ? DepthMode.SHALLOW : depthMode;
                OCGenerateCopyHandler.appendMember(strings, "copy." + property.getName(), "self." + property.getName(), type, (OCFile)element.getContainingFile(), propertyDepthMode, false);
                continue;
            }
            OCGenerateCopyHandler.appendMember(strings, "copy->" + ivar.getName(), ivar.getName(), type, (OCFile)element.getContainingFile(), depthMode, false);
        }
        for (String string : strings) {
            body.append(string);
        }
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        String templateName = classSymbol != null && !classSymbol.processMembersInAllCategories("copyWithZone:", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true) ? "OC Overridden CopyWithZone Body 1.m" : (strings.size() > 0 ? "OC Overridden CopyWithZone Body 2.m" : "OC Overridden CopyWithZone Body 3.m");
        return OCCallableUtil.methodFromTemplate(actionContext.getBaseMethod(), templateName, body.toString().trim(), element);
    }

    private static void appendMember(final List<String> strings, final String copyName, final String memberName, OCType type, final OCFile contextFile, final DepthMode depthMode, boolean isInNestedStruct) {
        if (type.isPointerToObject()) {
            if (depthMode == DepthMode.DEEP) {
                strings.add(copyName + "=[" + memberName + " copy];\n");
            } else if (!isInNestedStruct) {
                if (OCCompilerHelper.isArcEnabled(contextFile)) {
                    strings.add(copyName + "=" + memberName + ";\n");
                } else {
                    strings.add(copyName + "=[" + memberName + " retain];\n");
                }
            } else if (!OCCompilerHelper.isArcEnabled(contextFile)) {
                strings.add("[" + copyName + " retain];\n");
            }
        } else {
            if (!isInNestedStruct) {
                strings.add(copyName + "=" + memberName + ";\n");
            }
            OCGenerateCopyHandler.processStructFields(type, new Processor<OCDeclaratorSymbol>(){

                public boolean process(OCDeclaratorSymbol field) {
                    OCGenerateCopyHandler.appendMember(strings, copyName + "." + field.getName(), memberName + "." + field.getName(), field.getResolvedType(), contextFile, depthMode, true);
                    return true;
                }
            });
        }
    }

    protected static enum DepthMode {
        DEEP,
        SHALLOW;

    }
}

