/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCCppClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateConstructorHandler
extends OCCppClassTextActionHandlerBase<OCDeclaratorSymbol, OCGenerateConstructorContext> {
    @Override
    protected String getActionTitle() {
        return "Generate Constructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Fields to be Initialized";
    }

    @Override
    @NotNull
    protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, PsiElement context) {
        final ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        parent.processBaseClasses(new OCResolveContext((PsiElement)context.getContainingFile()), new OCStructSymbol.BaseClassProcessor(){

            @Override
            public boolean process(OCSymbol symbol, OCVisibility visibility) {
                if (symbol instanceof OCStructSymbol) {
                    CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                    ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)collector);
                    if (!collector.getResults().isEmpty()) {
                        baseConstructors.add(collector.getResults());
                    }
                }
                return true;
            }
        });
        return new OCGenerateConstructorContext(parent, context, baseConstructors);
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, final @NotNull PsiFile file2, @NotNull OCGenerateConstructorContext context, @NotNull List<OCDeclaratorSymbol> fields) {
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        for (OCFunctionSymbol baseConstructor : context.getBaseConstructors()) {
            paramTypes.addAll(baseConstructor.getType().getParameterTypes());
        }
        paramTypes.addAll(ContainerUtil.map(fields, (Function)new Function<OCDeclaratorSymbol, OCType>(){

            public OCType fun(OCDeclaratorSymbol symbol) {
                return symbol.getType();
            }
        }));
        final OCType functionType = new OCFunctionType(OCVoidType.instance(), paramTypes).resolve(file2);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                OCType type;
                return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && (type = symbol.getResolvedType()) instanceof OCFunctionType && new OCTypeEqualityVisitor(type, false, new OCResolveContext((PsiElement)file2)).isFunctionSignatureEqual(functionType);
            }
        };
        ((OCStructSymbol)context.getParent()).processMembers((String)null, (Processor<OCSymbol>)finder);
        if (finder.isFound()) {
            int code;
            String message = "Constructor " + ((OCFunctionSymbol)finder.getFoundValue()).getSignatureWithoutParamNames() + " is already defined.\nDo you wish to continue?";
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 1 : Messages.showYesNoDialog((String)message, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code != 0) {
                return;
            }
        }
        super.performAction(project2, editor, file2, context, fields);
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateConstructorContext context) {
        return true;
    }

    @Override
    protected boolean allowMultiSelection(OCGenerateConstructorContext context) {
        return ((OCStructSymbol)context.getParent()).getKind() == OCSymbolKind.STRUCT;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateConstructorContext context) {
        List<OCFunctionSymbol> chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(context.getAllBaseConstructors(), project2);
        if (chosenCtors != null) {
            context.setBaseConstructors(chosenCtors);
            super.invoke(project2, editor, file2, context);
        }
    }

    @Nullable
    public static List<OCFunctionSymbol> chooseBaseConstructors(List<Collection<OCFunctionSymbol>> allBaseConstructors, Project project2) {
        ArrayList<OCFunctionSymbol> chosenCtors = new ArrayList<OCFunctionSymbol>();
        for (Collection<OCFunctionSymbol> ctors : allBaseConstructors) {
            if (ctors.size() > 1) {
                OCFunctionSymbol ctr = OCGenerateConstructorHandler.chooseConstructor(ctors, project2);
                if (ctr != null) {
                    chosenCtors.add(ctr);
                    continue;
                }
                return null;
            }
            OCFunctionSymbol ctor = (OCFunctionSymbol)ContainerUtil.getFirstItem(ctors);
            if (ctor == null || ctor.canBeCalledWithoutArguments()) continue;
            chosenCtors.add(ctor);
        }
        return chosenCtors;
    }

    @Nullable
    private static OCFunctionSymbol chooseConstructor(Collection<OCFunctionSymbol> constructors, Project project2) {
        OCMemberChooser chooser = new OCMemberChooser((OCMemberChooserObject[])ContainerUtil.map2Array(constructors, OCMemberChooserObject.class, (Function)new Function<OCFunctionSymbol, OCMemberChooserObject>(){

            public OCMemberChooserObject fun(final OCFunctionSymbol symbol) {
                return new OCMemberChooserObject(symbol, null){

                    @Override
                    @Nullable
                    public MemberChooserObject getParentNodeDelegate() {
                        return new OCMemberChooserObject(symbol.getParent(), null);
                    }
                };
            }
        }), false, false, Collections.emptyList(), null, project2);
        chooser.setTitle("Choose Base Class Constructor");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
        } else {
            Disposer.dispose((Disposable)chooser.getDisposable());
        }
        List<OCMemberChooserObject> chosenElements = chooser.getChosenElements();
        assert (chosenElements != null && chosenElements.size() == 1);
        return (OCFunctionSymbol)chosenElements.get(0).getSymbol();
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCDeclaratorSymbol> members, OCGenerateConstructorContext actionContext) {
        if (element instanceof OCStruct && (at == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)at, (boolean)false))) {
            return ((OCStruct)element).getFunctionsStartOffset();
        }
        return super.getInsertPosition(element, caretOffset, at, members, actionContext);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateConstructorContext context) {
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        ArrayList<String> paramNames = new ArrayList<String>();
        HashSet<String> existingNames = new HashSet<String>();
        for (OCFunctionSymbol baseConstructor : context.getBaseConstructors()) {
            for (OCDeclaratorSymbol param : baseConstructor.getParameterSymbols()) {
                String name = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, param.getName(), null, existingNames);
                existingNames.add(name);
                OCType type = param.getType();
                paramTypes.add(OCTypeUtils.getExtractExpressionType(type, context.getContext(), type instanceof OCPointerType || type instanceof OCCppReferenceType));
                paramNames.add(name);
            }
        }
        for (OCDeclaratorSymbol field : fields) {
            String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field);
            name = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, name, null, existingNames);
            existingNames.add(name);
            OCType type = field.getType();
            paramTypes.add(OCTypeUtils.getExtractExpressionType(type, context.getContext(), type instanceof OCPointerType || type instanceof OCCppReferenceType));
            paramNames.add(name);
        }
        OCFunctionType type = new OCFunctionType(OCVoidType.instance(), paramTypes, paramNames);
        StringBuilder builder = new StringBuilder();
        int position = this.getInsertPosition(element, 0, at, fields, context);
        OCVisibility contextVisibility = OCVisibility.getVisibilityAtOffset(element, position);
        if (contextVisibility != OCVisibility.PUBLIC) {
            builder.append("public:");
        }
        builder.append(OCTypeNameVisitor.getFunctionSignature(context.getContext(), type, ((OCStructSymbol)context.getParent()).getName(), true, null));
        if (context.getBaseConstructors().size() + fields.size() > 0) {
            builder.append(":");
        }
        int paramIdx = 0;
        boolean firstCtor = true;
        for (OCFunctionSymbol baseConstructor : context.getBaseConstructors()) {
            if (!firstCtor) {
                builder.append(",");
            }
            firstCtor = false;
            builder.append(baseConstructor.getName()).append("(");
            for (int i = 0; i < baseConstructor.getParameterSymbols().size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)paramNames.get(paramIdx++));
            }
            builder.append(")");
        }
        for (OCDeclaratorSymbol field : fields) {
            if (paramIdx > 0) {
                builder.append(",");
            }
            builder.append(field.getName()).append("(").append((String)paramNames.get(paramIdx++)).append(")");
        }
        builder.append("{}\n");
        if (contextVisibility != OCVisibility.PUBLIC && OCGenerateConstructorHandler.needRestoreVisibility(element, position)) {
            builder.append((Object)contextVisibility).append(":\n");
        }
        return builder.toString();
    }
}

