/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCCheckboxMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMembersHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCMemberSymbol, OCDeclareActionContext> {
    @Override
    protected String getActionTitle() {
        return "Declare Members";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Members to Declare";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCDeclareActionContext context) {
        return context.getParentNameUppercase() + " has no members to declare";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    @Nullable
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCObjectType type = parent.getResolvedType(true);
        OCClassDeclarationBase definition = (OCClassDeclarationBase)parent.locateDefinition();
        if (!(definition instanceof OCClassDeclaration)) {
            return null;
        }
        OCClassDeclaration classDeclaration = (OCClassDeclaration)definition;
        OCDeclareActionContext actionContext = new OCDeclareActionContext(parent, classDeclaration, type);
        OCDeclareActionContext.Target defaultTarget = parent instanceof OCImplementationSymbol || "".equals(parent.getCategoryName()) ? OCDeclareActionContext.Target.INTERFACE : (parent.getCategoryName() != null ? OCDeclareActionContext.Target.IMPLEMENTATION : OCDeclareActionContext.Target.PRIVATE_CATEGORY);
        actionContext.setTarget(defaultTarget);
        return actionContext;
    }

    @Override
    protected OCMemberChooser createMemberChooser(Project project2, List<Pair<OCOption, Object>> options, final OCDeclareActionContext actionContext, List<OCMemberSymbol> candidates) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap((Collection<OCMemberSymbol>)candidates);
        MemberChooserHeaderPanel panel = new MemberChooserHeaderPanel(actionContext.getAvailableTargets(), actionContext.getTarget());
        final OCCheckboxMemberChooser chooser = new OCCheckboxMemberChooser(new OCMemberChooserObject[0], options, project2, this.allowEmptySelection(actionContext), this.allowMultiSelection(actionContext), panel){

            @Override
            protected boolean isMemberEnabled(OCMemberChooserObject member) {
                OCDeclareActionContext.Target target = actionContext.getTarget();
                OCClassSymbol targetSymbol = actionContext.getTargetSymbol();
                OCSymbol symbol = member.getSymbol();
                if (targetSymbol != null && (targetSymbol.equals(symbol) || targetSymbol.equals(parentsMap.get(symbol)))) {
                    return false;
                }
                if (target == OCDeclareActionContext.Target.IMPLEMENTATION && symbol instanceof OCPropertySymbol) {
                    return false;
                }
                return target != OCDeclareActionContext.Target.PRIVATE_CATEGORY || !(symbol instanceof OCInstanceVariableSymbol) || OCCompilerHelper.supportsIvarsInCategories();
            }
        };
        panel.addTargetChangeListener(new Processor<OCDeclareActionContext.Target>(){

            public boolean process(OCDeclareActionContext.Target target) {
                actionContext.setTarget(target);
                chooser.refreshChosenMembers();
                chooser.repaint();
                return true;
            }
        });
        chooser.refreshChosenMembers();
        return chooser;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, final @NotNull OCDeclareActionContext actionContext, final @NotNull List<OCMemberSymbol> chosenCandidates) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        final ArrayList elementsToDelete = new ArrayList();
        final ArrayList membersToAdd = new ArrayList();
        final OCClassSymbol targetSymbol = actionContext.getTargetSymbol();
        final OCClassDeclaration targetDeclFinal = targetSymbol != null ? (OCClassDeclaration)targetSymbol.locateDefinition() : null;
        OCInterfaceSymbol privateCategory = actionContext.getPrivateCategory();
        final HashSet membersOfPrivateCategory = new HashSet();
        if (privateCategory != null) {
            privateCategory.processMembers(OCMemberSymbol.class, new Processor<OCMemberSymbol>(){

                public boolean process(OCMemberSymbol symbol) {
                    if (!symbol.isSynthetic()) {
                        membersOfPrivateCategory.add(symbol);
                    }
                    return true;
                }
            });
        }
        boolean privateCategoryWasEmpty = membersOfPrivateCategory.isEmpty();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (OCMemberSymbol member : chosenCandidates) {
                    OCMemberSymbol definitionSymbol = (OCMemberSymbol)member.getDefinitionSymbol();
                    if (definitionSymbol != null) {
                        member = definitionSymbol;
                    }
                    Object memberElement = member.locateDefinition();
                    OCMemberSymbol declaration = member instanceof OCMethodSymbol ? member.getAssociatedSymbol() : member;
                    declaration = declaration != null ? declaration : member;
                    OCClassSymbol declarationParent = (OCClassSymbol)declaration.getParent();
                    membersOfPrivateCategory.remove(declaration);
                    if (declarationParent.equals(targetSymbol)) continue;
                    if (member instanceof OCMethodSymbol && declarationParent instanceof OCInterfaceSymbol && ((OCClassSymbol)actionContext.getParent()).getName().equals(declarationParent.getName())) {
                        elementsToDelete.add(declaration.locateDefinition());
                    }
                    if (targetSymbol != null && member instanceof OCPropertySymbol) {
                        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                        targetSymbol.processMembers(member.getName(), OCPropertySymbol.class, finder);
                        elementsToDelete.add(finder.isFound() ? (Object)((OCPropertySymbol)finder.getFoundValue()).locateDefinition() : null);
                    }
                    if (!(member instanceof OCInstanceVariableSymbol) && actionContext.getTarget() == OCDeclareActionContext.Target.IMPLEMENTATION) continue;
                    PsiElement anchor = targetDeclFinal != null ? targetDeclFinal.getBestMemberPlace(member) : null;
                    Object newElement = memberElement;
                    if (member instanceof OCMethodSymbol) {
                        String signature = OCCallableUtil.methodSignature((OCMethodSymbol)member, actionContext.getContext());
                        newElement = OCElementFactory.methodFromSignature(signature, actionContext.getContext(), false, true);
                    }
                    class AddMember {
                        PsiElement anchor;
                        PsiElement member;
                        OCMemberSymbol symbol;

                        AddMember(PsiElement anchor, PsiElement member, OCMemberSymbol symbol) {
                            this.anchor = anchor;
                            this.member = member;
                            this.symbol = symbol;
                        }
                    }
                    membersToAdd.add(new AddMember(anchor, (PsiElement)newElement, member));
                }
            }
        });
        if (privateCategory != null && targetSymbol != privateCategory && membersOfPrivateCategory.isEmpty() && !privateCategoryWasEmpty) {
            int code;
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)"Do you want to remove empty Private Category?", (String)"Remove Private Category", (Icon)Messages.getQuestionIcon());
            if (code == 2) {
                return;
            }
            if (code == 0) {
                elementsToDelete.add(privateCategory.locateDefinition());
            }
        }
        new WriteCommandAction(project2, this.getActionTitle(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                OCClassDeclarationBase implementation;
                OCClassDeclaration targetDecl = targetDeclFinal;
                if (actionContext.getTarget() == OCDeclareActionContext.Target.PRIVATE_CATEGORY && targetSymbol == null && (implementation = (OCClassDeclarationBase)actionContext.getImplementationSymbol().locateDefinition()) != null) {
                    targetDecl = OCElementFactory.interfaceByName(((OCClassSymbol)actionContext.getParent()).getName() + "()", implementation);
                    targetDecl = OCChangeUtil.addBefore(implementation.getParent(), targetDecl, implementation);
                }
                if (targetDecl == null) {
                    return;
                }
                for (AddMember add : membersToAdd) {
                    PsiElement newElement;
                    if (add.symbol instanceof OCMethodSymbol) {
                        newElement = OCChangeUtil.addBefore(targetDecl, add.member, add.anchor != null && add.anchor.isValid() ? add.anchor : null);
                    } else {
                        OCDeclaration newDeclaration = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)add.member);
                        if (add.symbol instanceof OCPropertySymbol) {
                            newDeclaration = newDeclaration.getParent();
                            assert (newDeclaration instanceof OCProperty);
                        }
                        newElement = OCDeclareMembersHandler.this.moveDeclaration(add.symbol instanceof OCInstanceVariableSymbol ? targetDecl.getInstanceVariablesList() : targetDecl, newDeclaration);
                    }
                    OCImportSymbolFix.fixAllSymbolsRecursively(newElement);
                }
                for (PsiElement element : elementsToDelete) {
                    if (element == null || !element.isValid()) continue;
                    OCChangeUtil.delete(element);
                }
            }
        }.execute();
    }

    protected PsiElement moveDeclaration(PsiElement parent, PsiElement declaration) {
        PsiElement newDeclaration = OCChangeUtil.add(parent, declaration);
        OCChangeUtil.delete(declaration);
        return newDeclaration;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCMemberSymbol> candidates, OCDeclareActionContext actionContext, int moreNodesLevel) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, (Function)new Function<OCMemberSymbol, OCMemberChooserObject>(){

            public OCMemberChooserObject fun(final OCMemberSymbol symbol) {
                return new OCMemberChooserObject(symbol, parentsMap){

                    @Override
                    @Nullable
                    public MemberChooserObject getParentNodeDelegate() {
                        OCClassSymbol parent = (OCClassSymbol)parentsMap.get(symbol);
                        OCDeclareActionContext.Target target = parent instanceof OCImplementationSymbol ? OCDeclareActionContext.Target.IMPLEMENTATION : ("".equals(parent.getCategoryName()) ? OCDeclareActionContext.Target.PRIVATE_CATEGORY : OCDeclareActionContext.Target.INTERFACE);
                        String targetName = target == OCDeclareActionContext.Target.IMPLEMENTATION ? "Implementation (undeclared)" : target.getName();
                        return new OCMemberChooserObject((OCSymbol)parent, targetName, parent.getIcon());
                    }
                };
            }
        });
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private final JComboBox comboBox;

        public MemberChooserHeaderPanel(OCDeclareActionContext.Target[] targets, OCDeclareActionContext.Target defaultTarget) {
            super(new BorderLayout());
            this.comboBox = new JComboBox<OCDeclareActionContext.Target>(targets);
            this.add((Component)this.comboBox, "Center");
            this.comboBox.setRenderer(new ListCellRendererWrapper<OCDeclareActionContext.Target>(){

                public void customize(JList list, OCDeclareActionContext.Target target, int index, boolean selected, boolean hasFocus) {
                    this.setText(target.getName());
                    this.setIcon(target.getIcon());
                }
            });
            this.comboBox.setSelectedItem((Object)defaultTarget);
            JLabel templatesLabel = new JLabel("Declare in: ");
            templatesLabel.setDisplayedMnemonic('T');
            templatesLabel.setLabelFor(this.comboBox);
            this.add((Component)templatesLabel, "West");
        }

        protected void addTargetChangeListener(final Processor<OCDeclareActionContext.Target> listener2) {
            this.comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    listener2.process((Object)((OCDeclareActionContext.Target)((Object)comboBox.getSelectedItem())));
                }
            });
        }
    }
}

