/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareActionContext
extends OCObjCActionContext<OCMemberSymbol> {
    private final OCClassDeclaration myClassDeclaration;
    protected final OCInterfaceSymbol myPrivateCategory;
    private Target myTarget;

    public OCDeclareActionContext(OCClassSymbol classSymbol, OCClassDeclaration classDeclaration, @Nullable OCObjectType type) {
        super(classSymbol, classDeclaration, type);
        this.myClassDeclaration = classDeclaration;
        this.myInterfaceSymbol = this.myInterfaceSymbol != null && "".equals(this.myInterfaceSymbol.getCategoryName()) ? this.myInterfaceSymbol.getMainInterface() : this.myInterfaceSymbol;
        this.myPrivateCategory = type != null ? (OCInterfaceSymbol)ContainerUtil.find(type.getCategoryInterfaces(), (Condition)new Condition<OCInterfaceSymbol>(){

            public boolean value(OCInterfaceSymbol symbol) {
                return "".equals(symbol.getCategoryName());
            }
        }) : null;
    }

    @Override
    @NotNull
    public Collection<OCMemberSymbol> getMemberCandidates() {
        OCMemberInfoStorage storage2 = new OCMemberInfoStorage(this.myClassDeclaration);
        return ContainerUtil.mapNotNull(storage2.getClassMemberInfos(this.getContext()), (Function)new Function<OCMemberInfo, OCMemberSymbol>(){

            public OCMemberSymbol fun(OCMemberInfo info) {
                return info.getSymbol() instanceof OCMemberSymbol ? (OCMemberSymbol)info.getSymbol() : null;
            }
        });
    }

    @Override
    public Map<OCSymbol, OCSymbol> createParentsMap(Collection<OCMemberSymbol> members) {
        HashMap<OCSymbol, OCSymbol> map = new HashMap<OCSymbol, OCSymbol>();
        for (OCMemberSymbol member : members) {
            if (member instanceof OCMethodSymbol) {
                OCMemberSymbol declaration = member.getAssociatedSymbol();
                map.put(member, (OCSymbol)(declaration != null && !declaration.isSynthetic() ? declaration.getParent() : member.getParent()));
                continue;
            }
            map.put(member, (OCSymbol)member.getParent());
        }
        return map;
    }

    public OCInterfaceSymbol getPrivateCategory() {
        return this.myPrivateCategory;
    }

    public Target getTarget() {
        return this.myTarget;
    }

    public Target[] getAvailableTargets() {
        if (this.myImplementationSymbol.getCategoryName() == null) {
            return new Target[]{Target.INTERFACE, Target.PRIVATE_CATEGORY, Target.IMPLEMENTATION};
        }
        return new Target[]{Target.INTERFACE, Target.IMPLEMENTATION};
    }

    public OCClassSymbol getTargetSymbol() {
        switch (this.myTarget) {
            case INTERFACE: {
                return this.myInterfaceSymbol;
            }
            case PRIVATE_CATEGORY: {
                return this.myPrivateCategory;
            }
            case IMPLEMENTATION: {
                return this.myImplementationSymbol;
            }
        }
        return null;
    }

    public void setTarget(Target target) {
        this.myTarget = target;
    }

    public static enum Target {
        INTERFACE("Interface", OCIcons.CodeAssistantClass),
        PRIVATE_CATEGORY("Private Category", OCIcons.CodeAssistantClassExtension),
        IMPLEMENTATION("Implementation (don't declare)", OCIcons.CodeAssistantClass);

        private final String myName;
        private Icon myIcon;

        private Target(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

