/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassTextActionHandlerBase<P extends OCMembersContainer, M extends OCSymbolWithParent<?, ?>, C extends OCActionContext<P, M>>
extends OCClassActionHandlerBase<P, M, C> {
    protected abstract int getInsertPosition(PsiElement var1, int var2, PsiElement var3, List<M> var4, C var5);

    @NotNull
    protected abstract String getInsertText(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull List<M> var3, @NotNull C var4);

    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        return false;
    }

    protected void selectResult(@NotNull PsiFile file2, @NotNull RangeMarker rangeMarker) {
        Editor editor;
        OCBlockStatement body;
        PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
        OCCallable firstMethod = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{OCCallable.class});
        if (firstMethod != null && (body = firstMethod.getBody()) != null && this.shouldSelectResult(body) && (editor = EditorHelper.openInEditor((PsiElement)file2)) != null) {
            OCCodeInsightUtil.selectBody(editor, body);
        }
    }

    @Override
    protected void performAction(@NotNull Project project2, final @Nullable Editor editor, final @NotNull PsiFile file2, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        LinkedList<PsiFile> files = new LinkedList<PsiFile>();
        for (PsiElement element : (List)this.getElementsToModify(actionContext).getFirst()) {
            files.add(element.getContainingFile());
        }
        new WriteCommandAction(project2, this.getActionTitle(), PsiUtilCore.toPsiFileArray(files), (OCActionContext)actionContext, project2, chosenCandidates){
            final /* synthetic */ OCActionContext val$actionContext;
            final /* synthetic */ Project val$project;
            final /* synthetic */ List val$chosenCandidates;
            {
                this.val$actionContext = oCActionContext;
                this.val$project = project2;
                this.val$chosenCandidates = list;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result) throws Throwable {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
                int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
                PsiElement at = null;
                if (editor != null && (at = file2.findElementAt(caretPos)) == null) {
                    at = file2.getLastChild();
                }
                Pair<List<PsiElement>, Integer> pair = OCClassTextActionHandlerBase.this.getElementsToModify(this.val$actionContext);
                List elements = (List)pair.getFirst();
                Integer originalElementIndex = (Integer)pair.getSecond();
                for (PsiElement element : elements) {
                    if (FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) continue;
                    return;
                }
                for (int i = 0; i < elements.size(); ++i) {
                    PsiElement element;
                    element = (PsiElement)elements.get(i);
                    if (!element.isValid()) continue;
                    VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                    if (virtualFile != null) {
                        CommandProcessor.getInstance().addAffectedFiles(this.val$project, new VirtualFile[]{virtualFile});
                    }
                    if (i == originalElementIndex) {
                        OCClassTextActionHandlerBase.this.performAction(this.val$project, element, caretPos, at, this.val$chosenCandidates, this.val$actionContext);
                        continue;
                    }
                    OCClassTextActionHandlerBase.this.performAction(this.val$project, element, -1, null, this.val$chosenCandidates, this.val$actionContext);
                }
            }
        }.execute();
    }

    protected Pair<List<PsiElement>, Integer> getElementsToModify(@NotNull C context) {
        int originalElementIndex = -1;
        ArrayList elements = new ArrayList();
        List<OCSymbol> symbols = ((OCActionContext)context).getSymbolsToModify();
        for (int i = 0; i < symbols.size(); ++i) {
            Object declaration;
            OCSymbol symbol = symbols.get(i);
            if (symbol == null || (declaration = symbol.locateDefinition()) == null) continue;
            elements.add(declaration);
            if (!symbol.equals(((OCActionContext)context).getParent())) continue;
            originalElementIndex = i;
        }
        return new Pair(elements, (Object)originalElementIndex);
    }

    protected void performAction(@NotNull Project project2, @NotNull PsiElement element, int caretPos, @Nullable PsiElement at, @NotNull List<M> members, @NotNull C context) {
        PsiFile file2 = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
        String insertText = this.getInsertText(element, at, members, context);
        if (insertText.isEmpty()) {
            return;
        }
        int insertOffset = this.getInsertPosition(element, caretPos, at, members, context);
        if (insertOffset == -1) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(insertOffset, insertOffset);
        rangeMarker.setGreedyToRight(true);
        document.insertString(insertOffset, (CharSequence)insertText);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        OCChangeUtil.reformatTextIfNotInjected(file2, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)file2, new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
        this.selectResult(file2, rangeMarker);
    }
}

