/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCOverrideImplementCppActionContext
extends OCCppActionContext<OCMembersContainer, OCFunctionSymbol> {
    private boolean myImplementMode;

    public OCOverrideImplementCppActionContext(OCMembersContainer parent, PsiElement context, boolean implementMode) {
        super(parent, context);
        this.myImplementMode = implementMode;
    }

    @Override
    @NotNull
    public Collection<OCFunctionSymbol> getMemberCandidates() {
        final ArrayList<OCFunctionSymbol> result = new ArrayList<OCFunctionSymbol>();
        if (this.getParent() instanceof OCStructSymbol) {
            OCStructType.processMembersInBaseTypes((OCStructSymbol)this.getParent(), null, false, false, new Condition<OCSymbol>(){

                public boolean value(OCSymbol symbol) {
                    if (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isStatic()) {
                        String newName = OCCallableUtil.getNewFunctionName((OCFunctionSymbol)symbol, (OCStructSymbol)OCOverrideImplementCppActionContext.this.getParent());
                        final OCTypeEqualityVisitor equalityVisitor = new OCTypeEqualityVisitor(symbol.getResolvedType(), false, new OCResolveContext(OCOverrideImplementCppActionContext.this.getContext()));
                        if (((OCStructSymbol)OCOverrideImplementCppActionContext.this.getParent()).processMembers(newName, new Processor<OCSymbol>(){

                            public boolean process(OCSymbol existingSymbol) {
                                return !(existingSymbol instanceof OCFunctionSymbol) || !equalityVisitor.isFunctionSignatureEqual(existingSymbol.getResolvedType());
                            }
                        }) && (((OCFunctionSymbol)symbol).getVisibility() != OCVisibility.PRIVATE || ((OCFunctionSymbol)symbol).isVirtual())) {
                            return true;
                        }
                    }
                    return false;
                }
            }, new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (!OCOverrideImplementCppActionContext.this.myImplementMode || ((OCFunctionSymbol)symbol).isPureVirtual()) {
                        result.add((OCFunctionSymbol)symbol);
                    }
                    return true;
                }
            }, new OCResolveContext((PsiElement)this.getContext().getContainingFile()));
        }
        return result;
    }
}

