/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDefinitionQuickFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final boolean myInline;

    public OCGenerateDefinitionQuickFix(@Nullable OCFunctionSymbol symbol, boolean inline) {
        super(symbol);
        this.myInline = inline;
    }

    @Override
    protected boolean isAvailable(OCFunctionSymbol symbol) {
        return OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol);
    }

    @Override
    protected String getTextInternal(OCFunctionSymbol symbol) {
        return this.myInline ? OCBundle.message("generate.definitions.quickfix.inlineText", symbol.getNameWithKindLowercase()) : OCBundle.message("generate.definitions.quickfix.outsideText", symbol.getNameWithKindLowercase());
    }

    @Override
    protected void invoke(@NotNull OCFunctionSymbol symbol) {
        if (this.isAvailable(symbol)) {
            PsiFile file2 = symbol.getContainingPsiFile();
            assert (file2 != null);
            List<OCFunctionSymbol> candidates = Collections.singletonList(symbol);
            List<OCGenerateUtil.Replacement> replacements = this.myInline ? OCCppDefinitionsUtil.getInlineReplacements(file2, candidates) : OCCppDefinitionsUtil.getOutsideReplacementsAtPreferredPosition(file2, candidates);
            OCGenerateUtil.applyReplacements(file2.getProject(), this.getTextInternal(symbol), replacements);
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
    }
}

