/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCppClassTextActionHandlerBase<M extends OCSymbolWithQualifiedName<?>, C extends OCCppActionContext<OCStructSymbol, M>>
extends OCClassTextActionHandlerBase<OCStructSymbol, M, C> {
    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return OCCodeInsightUtil.isValid((PsiElement)file2);
    }

    @Override
    protected Pair<List<PsiElement>, Integer> getElementsToModify(@NotNull C context) {
        Object element = ((OCStructSymbol)((OCActionContext)context).getParent()).locateDefinition();
        return new Pair(Collections.singletonList(element != null ? element : ((OCActionContext)context).getContext().getContainingFile()), (Object)0);
    }

    @Override
    @NotNull
    protected List<C> getContexts(@NotNull Project project2, final @Nullable Editor editor, final @NotNull PsiFile psiFile) {
        OCFile file2 = (OCFile)psiFile;
        final PsiElement context = OCGenerateUtil.getElementAt(editor, psiFile);
        OCStructLike struct = (OCStructLike)PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCUnion.class});
        List<OCStructSymbol> parents = new ArrayList<OCStructSymbol>();
        if (struct != null) {
            OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
            if (symbol != null && !symbol.isPredeclaration()) {
                parents.add(symbol);
            }
        } else {
            OCFile header;
            CommonProcessors.CollectProcessor<OCStructSymbol> collector = new CommonProcessors.CollectProcessor<OCStructSymbol>(){

                protected boolean accept(OCStructSymbol symbol) {
                    return (symbol.getKind() == OCSymbolKind.STRUCT || symbol.getKind() == OCSymbolKind.UNION) && !symbol.isPredeclaration();
                }
            };
            OCCommonProcessors.TypeFilteredProcessor processor2 = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCStructSymbol>)collector, OCStructSymbol.class);
            file2.processSymbolsRecursively(processor2);
            OCFile oCFile = header = file2.isHeader() ? file2 : file2.getAssociatedFile();
            if (!file2.isHeader() && header != null) {
                header.processSymbolsRecursively(processor2);
            }
            OCCppNamespace namespace = (OCCppNamespace)PsiTreeUtil.getParentOfType((PsiElement)context, OCCppNamespace.class);
            for (OCStructSymbol parent : collector.getResults()) {
                parents.add(parent);
            }
            if (header != null && namespace != null) {
                OCNamespaceSymbol namespaceSymbol;
                OCNamespaceSymbol oCNamespaceSymbol = namespaceSymbol = file2.isHeader() ? (OCNamespaceSymbol)namespace.getSymbol() : header.findSymbol(namespace.getName(), OCNamespaceSymbol.class);
                if (namespaceSymbol != null) {
                    parents.clear();
                    for (OCStructSymbol parent : collector.getResults()) {
                        if (parent.getParent() != namespaceSymbol) continue;
                        parents.add(parent);
                    }
                } else {
                    return Collections.emptyList();
                }
            }
            parents = ContainerUtil.filter(parents, (Condition)new Condition<OCStructSymbol>(){

                public boolean value(OCStructSymbol container) {
                    OCCppActionContext actionContext = (OCCppActionContext)OCCppClassTextActionHandlerBase.this.evaluateActionContext(container, context);
                    return actionContext != null && (!actionContext.getMemberCandidates().isEmpty() || OCCppClassTextActionHandlerBase.this.allowEmptySelection(actionContext));
                }
            });
        }
        return ContainerUtil.map(parents, (Function)new Function<OCStructSymbol, C>(){

            public C fun(OCStructSymbol p) {
                return (OCCppActionContext)OCCppClassTextActionHandlerBase.this.evaluateActionContext(p, OCGenerateUtil.getElementAt(editor, psiFile));
            }
        });
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<M> members, C actionContext) {
        if ((at = this.getInsertContext(element, at, actionContext)) == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(at)) && at == element.getLastChild()) {
            return element.getTextRange().getEndOffset();
        }
        int offset = at.getTextRange().getStartOffset();
        if (element instanceof OCStruct && ((OCStruct)element).getHeaderRange().containsOffset(offset)) {
            return ((OCStruct)element).getFunctionsStartOffset();
        }
        return offset;
    }

    @Override
    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        return true;
    }

    @Nullable
    protected PsiElement getInsertContext(PsiElement element, PsiElement at, C actionContext) {
        PsiElement anchor;
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class});
        boolean afterClass = element instanceof PsiFile && parent instanceof OCStruct;
        PsiElement psiElement = parent = parent instanceof OCCppNamespace ? parent : element;
        if (element instanceof OCFile && at == null) {
            parent = OCChangeUtil.findInsertionParentInFile((OCFile)element, (OCNamespaceSymbol)((OCActionContext)actionContext).getParent());
        }
        at = (anchor = OCChangeUtil.getRealAnchorForInsertion(parent, at)) != null ? anchor : at;
        return afterClass ? at.getNextSibling() : at;
    }

    protected static boolean needRestoreVisibility(PsiElement element, int offset) {
        if (!(element instanceof OCStruct)) {
            return false;
        }
        PsiElement at = element.getContainingFile().findElementAt(offset);
        PsiElement nextLeaf = at != null ? PsiTreeUtil.firstChild((PsiElement)at) : null;
        IElementType leafType = OCElementUtil.getElementType(nextLeaf);
        while (nextLeaf != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(leafType)) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            leafType = OCElementUtil.getElementType(nextLeaf);
        }
        return nextLeaf == null || !OCElementUtil.isCPPVisibilityKeyword(nextLeaf.getNode()) && (leafType != OCTokenTypes.RBRACE || !(nextLeaf.getParent() instanceof OCStruct));
    }
}

