/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class OCMemberChooserObject
extends MemberChooserObjectBase
implements ClassMember {
    private OCSymbol mySymbol;
    private Map<OCSymbol, OCSymbol> myParentsMap;

    public OCMemberChooserObject(OCSymbol symbol, String text, Icon icon) {
        super(text, icon);
        this.mySymbol = symbol;
    }

    private OCMemberChooserObject(OCSymbol symbol, OCSymbol delegateSymbol, Map<OCSymbol, OCSymbol> parentsMap) {
        this(symbol, OCMemberChooserObject.getPresentableText(delegateSymbol), delegateSymbol.getIcon());
        this.myParentsMap = parentsMap;
    }

    public OCMemberChooserObject(OCSymbol symbol, Icon icon, Map<OCSymbol, OCSymbol> parentsMap) {
        this(symbol, OCMemberChooserObject.getPresentableText(symbol), icon);
        this.myParentsMap = parentsMap;
    }

    public OCMemberChooserObject(OCSymbol symbol, Map<OCSymbol, OCSymbol> parentsMap) {
        this(symbol, OCMemberChooserObject.getDelegateSymbol(symbol), parentsMap);
    }

    private static OCSymbol getDelegateSymbol(OCSymbol symbol) {
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar()) {
            OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty();
            return property != null ? property : symbol;
        }
        return symbol;
    }

    private static String getPresentableText(OCSymbol target) {
        if (target instanceof OCFunctionSymbol) {
            return ((OCFunctionSymbol)target).getSignatureWithoutParamNames();
        }
        if (target instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)target).isGlobalNamespace()) {
            VirtualFile file2 = target.getContainingFile();
            return file2 != null ? file2.getName() : "";
        }
        return target.getPresentableName();
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OCMemberChooserObject that = (OCMemberChooserObject)((Object)o);
        return !(this.mySymbol != null ? !this.mySymbol.equals(that.mySymbol) : that.mySymbol != null);
    }

    public int hashCode() {
        return this.mySymbol != null ? this.mySymbol.hashCode() : 0;
    }

    @Nullable
    public MemberChooserObject getParentNodeDelegate() {
        OCSymbol parent = this.myParentsMap != null ? this.myParentsMap.get(this.mySymbol) : null;
        return parent != null ? new OCMemberChooserObject(parent, this.myParentsMap) : null;
    }
}

