/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateUtil {
    @NotNull
    public static PsiElement getElementAt(@Nullable Editor editor, @NotNull PsiFile file2) {
        PsiElement at = editor != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : null;
        return at != null ? at : file2;
    }

    public static void applyReplacements(final @NotNull Project project2, @NotNull String actionName, final @NotNull List<Replacement> replacements) {
        final HashMap<PsiFile, Document> files = new HashMap<PsiFile, Document>();
        for (Replacement r : replacements) {
            files.put(r.position.file, r.position.marker.getDocument());
        }
        new WriteCommandAction(project2, actionName, files.keySet().toArray(new PsiFile[files.size()])){

            protected void run(@NotNull Result result) throws Throwable {
                for (Document document : files.values()) {
                    PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                }
                for (Replacement r : replacements) {
                    ReplacePosition p = r.position;
                    Document document = p.marker.getDocument();
                    document.replaceString(p.marker.getStartOffset(), p.marker.getEndOffset(), (CharSequence)r.text);
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                    OCChangeUtil.reformatTextIfNotInjected(p.file, p.marker.getStartOffset(), p.marker.getEndOffset());
                    OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)p.file, new TextRange(p.marker.getStartOffset(), p.marker.getEndOffset()));
                }
                if (!replacements.isEmpty()) {
                    Replacement last = (Replacement)replacements.get(replacements.size() - 1);
                    VirtualFile virtualFile = last.position.file.getVirtualFile();
                    if (virtualFile != null) {
                        FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile, last.position.marker.getEndOffset()), true);
                    }
                }
            }
        }.execute();
    }

    public static class Replacement {
        @NotNull
        public final ReplacePosition position;
        @NotNull
        public final String text;

        public Replacement(@NotNull ReplacePosition position, @NotNull String text) {
            this.position = position;
            this.text = position.addNewlineBefore ? "\n" + text : text;
        }
    }

    public static class ReplacePosition {
        @NotNull
        public final RangeMarker marker;
        @NotNull
        public final PsiFile file;
        @NotNull
        public final PsiElement context;
        public final boolean addNewlineBefore;

        public ReplacePosition(@NotNull RangeMarker marker, @NotNull PsiFile file2, @NotNull PsiElement context, boolean addNewlineBefore) {
            this.marker = marker;
            this.file = file2;
            this.context = context;
            this.addNewlineBefore = addNewlineBefore;
        }
    }
}

