/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppDefinitionsUtil {
    public static boolean shouldGenerateDefinitionsFor(@NotNull OCFunctionSymbol symbol) {
        PsiFile file2 = symbol.getContainingPsiFile();
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return false;
        }
        if (symbol.isPureVirtual()) {
            return false;
        }
        return symbol.processSameSymbols(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                return symbol.isPredeclaration() && (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isDefault() && !((OCFunctionSymbol)symbol).isDelete());
            }
        });
    }

    @Contract(value="null, _, _ -> false")
    public static boolean shouldInline(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable OCMembersContainer parent) {
        if (!(parent instanceof OCSymbol)) {
            return false;
        }
        OCSymbol parentSymbol = (OCSymbol)((Object)parent);
        return PsiTreeUtil.isAncestor(parentSymbol.locateDefinition(), (PsiElement)OCGenerateUtil.getElementAt(editor, file2), (boolean)false);
    }

    public static List<OCGenerateUtil.Replacement> getInlineReplacements(@NotNull PsiFile file2, @NotNull List<OCFunctionSymbol> functions) {
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            OCLog.LOG.warn("No document for " + file2);
            return Collections.emptyList();
        }
        ArrayList<OCGenerateUtil.Replacement> replacements = new ArrayList<OCGenerateUtil.Replacement>(functions.size());
        for (OCFunctionSymbol symbol : functions) {
            PsiElement lastChild;
            OCFunctionDeclaration declaration = symbol.locateFunctionDefinition();
            if (declaration == null || OCElementUtil.getElementType(lastChild = declaration.getLastChild()) != OCTokenTypes.SEMICOLON) continue;
            OCFunctionSymbol baseToCall = OCFunctionAncestorsQuery.findFirstNonPure(symbol, false);
            String body = OCCallableUtil.defaultFunctionBody(symbol, baseToCall, declaration);
            RangeMarker marker = document.createRangeMarker(lastChild.getTextRange());
            marker.setGreedyToRight(true);
            replacements.add(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(marker, file2, declaration, true), body));
        }
        return replacements;
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getOutsideReplacementsAtPreferredPosition(@NotNull PsiFile file2, @NotNull List<OCFunctionSymbol> functions) {
        return OCCppDefinitionsUtil.getOutsideReplacementsAtPreferredPosition(file2, functions, null, OCCppDefinitionsUtil.defaultFallbackLocation(file2, functions));
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getOutsideReplacementsAtPreferredPosition(@NotNull PsiFile file2, @NotNull List<OCFunctionSymbol> functions, @Nullable List<OCFunctionSymbol> basesToCall, @NotNull PsiElement fallbackLocation) {
        OCGenerateUtil.ReplacePosition position = OCCppDefinitionsUtil.getOutsidePreferredPosition(file2, functions, fallbackLocation);
        if (position == null) {
            OCLog.LOG.warn("Can't find preferred outside position for file '" + file2 + "'");
            return Collections.emptyList();
        }
        return OCCppDefinitionsUtil.getOutsideReplacements(position, functions, basesToCall);
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getOutsideReplacementsAtCaretPosition(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull List<OCFunctionSymbol> functions, @Nullable List<OCFunctionSymbol> basesToCall) {
        OCGenerateUtil.ReplacePosition position = OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(editor.getCaretModel().getOffset(), file2);
        if (position == null) {
            OCLog.LOG.warn("Can't find preferred outside position for file '" + file2 + "'");
            return Collections.emptyList();
        }
        return OCCppDefinitionsUtil.getOutsideReplacements(position, functions, basesToCall);
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getOutsidePreferredPosition(@NotNull PsiFile file2, @NotNull List<OCFunctionSymbol> functions, @NotNull PsiElement fallbackLocation) {
        OCFile sourceFile;
        if (functions.isEmpty() || !(file2 instanceof OCFile)) {
            return null;
        }
        boolean hasTemplates = false;
        for (OCFunctionSymbol symbol : functions) {
            if (!file2.equals(symbol.getContainingPsiFile())) continue;
            OCSymbolWithQualifiedName parent = symbol.getParent();
            if (symbol.isTemplateSymbol() || parent instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)parent)).isTemplateSymbol()) {
                hasTemplates = true;
            }
            OCMembersContainer container = parent instanceof OCMembersContainer ? (OCMembersContainer)((Object)parent) : ((OCFile)file2).getMembersContainer(false);
            class OffsetProcessor
            implements Processor {
                public int maxOffset = 0;
                public PsiFile file = null;

                OffsetProcessor() {
                }

                public boolean process(Object o) {
                    PsiFile definitionFile;
                    Object definition;
                    OCSymbol definitionSymbol;
                    if (!(o instanceof OCSymbol)) {
                        return true;
                    }
                    OCSymbol symbol = (OCSymbol)o;
                    if (symbol.isPredeclaration() && (definitionSymbol = symbol.getDefinitionSymbol()) != null && (definition = definitionSymbol.locateDefinition()) != null && (definitionFile = definition.getContainingFile()) != null) {
                        if (this.file == null && OCCodeInsightUtil.isValid((PsiElement)definitionFile)) {
                            this.file = definitionFile;
                        }
                        if (this.file != null && this.file.equals(definitionFile)) {
                            this.maxOffset = Math.max(this.maxOffset, definition.getTextRange().getEndOffset());
                        }
                    }
                    return true;
                }
            }
            OffsetProcessor processor2 = new OffsetProcessor();
            container.processMembers(null, processor2);
            if (processor2.file == null) continue;
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(processor2.maxOffset, processor2.file);
        }
        if (((OCFile)file2).isHeader() && !hasTemplates && (sourceFile = ((OCFile)file2).getAssociatedFile()) != null && !sourceFile.isHeader()) {
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(sourceFile.getTextRange().getEndOffset(), sourceFile);
        }
        return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(fallbackLocation.getTextRange().getEndOffset(), fallbackLocation.getContainingFile());
    }

    @Nullable
    public static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(int originalOffset, @NotNull PsiFile file2) {
        PsiElement atCaret;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            OCLog.LOG.warn("No document for " + file2);
            return null;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret = (PsiElement)ObjectUtils.notNull((Object)file2.findElementAt(originalOffset), (Object)file2); curr != null; curr = curr.getParent()) {
            if (curr instanceof OCCppNamespace || curr instanceof PsiFile) {
                int preferredOffset = -1;
                PsiElement context = null;
                if (curr instanceof OCCppNamespace && prev != null) {
                    boolean insideNamespaceHeader = false;
                    for (PsiElement nsChild = curr.getFirstChild(); nsChild != curr.getLastChild(); nsChild = nsChild.getNextSibling()) {
                        if (nsChild.equals(prev)) {
                            insideNamespaceHeader = true;
                        }
                        if (OCElementUtil.getElementType(nsChild) != OCTokenTypes.LBRACE) continue;
                        if (!insideNamespaceHeader) break;
                        context = curr;
                        preferredOffset = nsChild.getTextRange().getEndOffset();
                        break;
                    }
                }
                if (context == null) {
                    if (prev == atCaret || prev == null) {
                        preferredOffset = originalOffset;
                        context = (PsiElement)ObjectUtils.notNull((Object)prev, (Object)curr);
                    } else {
                        preferredOffset = prev.getTextRange().getEndOffset();
                        context = prev;
                    }
                }
                RangeMarker marker = document.createRangeMarker(preferredOffset, preferredOffset);
                marker.setGreedyToRight(true);
                return new OCGenerateUtil.ReplacePosition(marker, file2, context, true);
            }
            prev = curr;
        }
        return null;
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> getOutsideReplacements(@NotNull OCGenerateUtil.ReplacePosition position, @NotNull List<OCFunctionSymbol> functions, @Nullable List<OCFunctionSymbol> basesToCall) {
        if (basesToCall == null) {
            basesToCall = ContainerUtil.map(functions, (Function)new Function<OCFunctionSymbol, OCFunctionSymbol>(){

                public OCFunctionSymbol fun(OCFunctionSymbol symbol) {
                    return symbol.isCppDestructor() || symbol.isCppConstructor() && symbol.getType().hasNoParameters() ? null : OCFunctionAncestorsQuery.findFirstNonPure(symbol, false);
                }
            });
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < functions.size(); ++i) {
            OCFunctionSymbol function = functions.get(i);
            OCFunctionSymbol baseToCall = (OCFunctionSymbol)basesToCall.get(i);
            String qualifier = OCCallableUtil.getFunctionParentQualifier(function, position.context, function.isFriendFunction());
            text.append(OCCallableUtil.exactFunctionText(OCCallableUtil.removeDeclarationSpecifiers(function), qualifier, true, baseToCall, position.context));
            text.append("\n");
        }
        return Collections.singletonList(new OCGenerateUtil.Replacement(position, text.toString()));
    }

    @NotNull
    private static PsiElement defaultFallbackLocation(@NotNull PsiFile file2, @NotNull List<OCFunctionSymbol> functions) {
        int maxOffset = -1;
        Object result = null;
        for (OCFunctionSymbol symbol : functions) {
            OCFunctionDeclaration definition = symbol.locateFunctionDefinition();
            if (definition == null) continue;
            int offset = definition.getTextRange().getEndOffset();
            if (!file2.equals(definition.getContainingFile()) || offset <= maxOffset) continue;
            maxOffset = offset;
            result = definition;
        }
        return result != null ? result : file2;
    }
}

