/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.alignment.AlignmentInColumnsConfig;
import com.intellij.formatting.alignment.AlignmentInColumnsHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.formatting.OCFormatProcessor;
import com.jetbrains.cidr.lang.formatting.OCFormatterInfo;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCLocalFormatterData;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCWrappingProcessor
extends OCFormatProcessor {
    protected static final Key<Boolean> IS_TABLE = new Key("IS_TABLE");
    private static final AlignmentInColumnsConfig VARS_ALIGNMENT_CONFIG = new AlignmentInColumnsConfig(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER}), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITESPACES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.COMMA, OCElementTypes.MACRO_CALL})}), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.COMMENTS, OCTokenTypes.TYPE_MODIFIERS}), TokenSet.EMPTY, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.ASSIGNMENT_EXPRESSION, OCElementTypes.DECLARATOR}));
    public static final OCElementType CHAINED_CALL_PSEUDOTYPE = new OCElementType("CHAINED_CALL_PSEUDOTYPE");
    public static final OCElementType BINARY_EXPRESSION_PSEUDOTYPE = new OCElementType("BINARY_EXPRESSION_PSEUDOTYPE");
    private static final String KEY_METHOD_ARGUMENTS = "method arguments";
    private static final String KEY_METHOD_FIRST_ARGUMENT = "first method argument";
    private static final String KEY_METHOD_ARGUMENT_VALUES = "method argument values";
    private static final String KEY_METHOD_CHAIN = "method argument alignment";
    private static final String KEY_CALL_ARGUMENT_COLUMNS = "call argument columns";
    private static final String KEY_PARAMETER_COLUMNS = "parameter columns";
    private static final String KEY_ASSIGNMENT_WRAP = "assignment wrap";
    private static final String KEY_ASSIGNMENT_ALIGNMENT = "assignment alignment";
    private static final String KEY_GROUP_ASSIGNMENT = "group assignment";
    private static final String KEY_GROUP_VARIABLE_NAME = "group variable name";
    private static final String KEY_GROUP_INIT_LIST = "group initialization list";
    private static final String KEY_GROUP_DICTIONARY_PAIRS = "group dictionary pairs";
    private static final String KEY_TERNARY_ALIGNMENT = "ternary alignment";
    private static final String KEY_TERNARY_OPERATOR_ALIGNMENT = "ternary operator alignment";
    private static final String KEY_TERNARY_WRAP = "ternary wrap";
    private static final String KEY_TERNARY_OPERATOR_WRAP = "ternary operator wrap";
    private static final String KEY_TEMPLATE_DECLARATION_WRAP = "template declaration wrap";
    private static final String KEY_NEVER_WRAP = "Never wrap";
    private static final String KEY_ALWAYS_WRAP = "Always wrap";
    private static final String KEY_IF_LONG_WRAP = "If long wrap";
    private static final TokenSet COMMENTS_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.COMMENTS, OCElementTypes.EXPRESSIONS});
    private static final TokenSet TYPE_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.TYPE_ELEMENT}), OCElementTypes.EXPRESSIONS});
    private static final TokenSet MACRO_ARG_OR_EXPRESSION = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_ARGUMENT}), OCElementTypes.EXPRESSIONS});
    private final OCLocalFormatterData myData;
    private ASTNode childNode;
    private IElementType childType;

    OCWrappingProcessor(CommonCodeStyleSettings settings, OCCodeStyleSettings ocSettings, ASTNode node, OCLocalFormatterData data) {
        super(settings, ocSettings, node);
        this.myData = data;
    }

    public Wrap getTemplateWrap(IElementType ancestorType) {
        OCFormatterInfo formatInfo;
        OCLocalFormatterData upData;
        OCLocalFormatterData oCLocalFormatterData = upData = ancestorType == null ? this.myData : this.myData.getAncestor(ancestorType);
        if (upData != null && (formatInfo = upData.get(KEY_TEMPLATE_DECLARATION_WRAP)) != null) {
            return formatInfo.wrap;
        }
        return null;
    }

    public OCFormatterInfo calculate(ASTNode child, IElementType childType) {
        this.childNode = child;
        this.childType = childType;
        return this.doCalculate();
    }

    private boolean shouldAlignAsElementOrComma(@NotNull IElementType elementType, boolean commaOnNextLine) {
        if (commaOnNextLine && this.childType == OCTokenTypes.COMMA) {
            return OCFormatterUtil.isPrecededBy(this.childNode, elementType);
        }
        return !(this.childType != OCElementTypes.MACRO_CALL && this.childType != elementType || commaOnNextLine && OCFormatterUtil.isPrecededBy(this.childNode, OCTokenTypes.COMMA));
    }

    private boolean shouldAlignAsElementOrComma(@NotNull TokenSet elementTypes, boolean commaOnNextLine) {
        if (commaOnNextLine && this.childType == OCTokenTypes.COMMA) {
            return OCFormatterUtil.isPrecededBy(this.childNode, elementTypes);
        }
        return !(this.childType != OCElementTypes.MACRO_CALL && !elementTypes.contains(this.childType) || commaOnNextLine && OCFormatterUtil.isPrecededBy(this.childNode, OCTokenTypes.COMMA));
    }

    @NotNull
    private static Pair<Object, ASTNode> getAssignGroupKey(@NotNull ASTNode node) {
        IElementType pType;
        int nestLevel = -1;
        ASTNode topContainer = node;
        for (ASTNode p = node; p != null && !OCWrappingProcessor.isVariableScope(pType = OCElementUtil.getElementType(p)); p = p.getTreeParent()) {
            if (pType != OCElementTypes.ASSIGNMENT_EXPRESSION && pType != OCElementTypes.DECLARATOR) continue;
            topContainer = p;
            ++nestLevel;
        }
        if (nestLevel < 0) {
            nestLevel = 0;
        }
        return new Pair((Object)new Pair((Object)KEY_GROUP_ASSIGNMENT, (Object)nestLevel), (Object)topContainer);
    }

    @NotNull
    private static String getInitListGroupKey(@NotNull ASTNode node) {
        String path = "";
        int oldSiblingOrder = 0;
        for (ASTNode p = node; p != null && OCElementUtil.getElementType(p.getTreeParent()) == OCElementTypes.COMPOUND_INITIALIZER; p = p.getTreeParent()) {
            int siblingOrder = 0;
            ASTNode s = p;
            while (s != null) {
                ++siblingOrder;
                s = OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(s);
            }
            if (oldSiblingOrder > 0) {
                path = new StringBuffer(path.length() + 32).append('/').append(oldSiblingOrder).append(path).toString();
            }
            oldSiblingOrder = siblingOrder;
        }
        return KEY_GROUP_INIT_LIST + path;
    }

    @NotNull
    private OCFormatterInfo doCalculate() {
        Alignment alignment;
        OCFormatterInfo result;
        OCForStatement psi;
        if (this.ocSettings.DO_NOT_ADD_BREAKS) {
            return this.getJoinFormatting();
        }
        if (this.childType == OCElementTypes.METHOD_SELECTOR_PART) {
            return this.wrapAndAlign((Object)OCElementTypes.METHOD_SELECTOR_PART, this.ocSettings.METHOD_PARAMETERS_WRAP, this.ocSettings.METHOD_PARAMETERS_ALIGN_MULTILINE);
        }
        if (this.thisType == OCElementTypes.PARAMETER_LIST) {
            if (this.shouldAlignAsElementOrComma(OCElementTypes.PARAMETER_DECLARATION, this.ocSettings.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE)) {
                return this.wrapAndAlign((Object)OCElementTypes.PARAMETER_LIST, this.ocSettings.FUNCTION_PARAMETERS_WRAP, this.ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE);
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.PARAMETER_DECLARATION) {
                return this.getJoinFormatting();
            }
        }
        if (this.thisType == OCElementTypes.ARGUMENT_LIST || this.thisType == OCElementTypes.MACRO_CALL) {
            if (this.shouldAlignAsElementOrComma(MACRO_ARG_OR_EXPRESSION, this.ocSettings.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE)) {
                return this.wrapAndAlign((Object)OCElementTypes.ARGUMENT_LIST, this.ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP, this.ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE);
            }
            if (this.childType == OCTokenTypes.COMMA || MACRO_ARG_OR_EXPRESSION.contains(this.childType)) {
                return this.getJoinFormatting();
            }
        }
        if (this.thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
            if (this.shouldAlignAsElementOrComma(OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION, this.ocSettings.TEMPLATE_PARAMETERS_COMMA_ON_NEXT_LINE)) {
                return this.wrapAndAlign((Object)OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST, this.ocSettings.TEMPLATE_PARAMETERS_WRAP, this.ocSettings.TEMPLATE_PARAMETERS_ALIGN_MULTILINE);
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION) {
                return this.getJoinFormatting();
            }
        }
        if (this.thisType == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
            if (this.shouldAlignAsElementOrComma(TYPE_OR_EXPRESSION, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE)) {
                return this.wrapAndAlign((Object)OCElementTypes.TEMPLATE_ARGUMENT_LIST, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_WRAP, this.ocSettings.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE);
            }
            if (this.childType == OCTokenTypes.COMMA || TYPE_OR_EXPRESSION.contains(this.childType)) {
                return this.getJoinFormatting();
            }
        }
        if (this.thisType == OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST || this.thisType == OCElementTypes.DECLARATOR && this.childType == OCTokenTypes.COLON) {
            final OCLocalFormatterData dataStorage = this.thisType == OCElementTypes.DECLARATOR ? this.myData : this.myData.getParent();
            OCFormatterInfo ret = dataStorage.get((Object)OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST, new Computable<OCFormatterInfo>(){

                public OCFormatterInfo compute() {
                    return OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)dataStorage).wrap, (WrapType)WrapType.byLegacyRepresentation((int)OCWrappingProcessor.this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP), (boolean)true), (Alignment)(OCWrappingProcessor.this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE ? Alignment.createAlignment() : null));
                }
            });
            if (this.childType == OCTokenTypes.COLON) {
                switch (this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON) {
                    case 0: {
                        return OCWrappingProcessor.getJoinFormatting(dataStorage);
                    }
                    case 1: {
                        return OCWrappingProcessor.getNewLineFormatting(dataStorage);
                    }
                }
                return OCWrappingProcessor.getIfLongFormatting(dataStorage);
            }
            if (this.shouldAlignAsElementOrComma(OCElementTypes.CPP_CONSTRUCTOR_FIELD_INITIALIZER, this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE)) {
                if (OCFormatterUtil.isFirstEssentialChild(this.childNode)) {
                    switch (this.ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON) {
                        case 0: {
                            return OCFormatterInfo.createInfo(OCWrappingProcessor.getJoinFormatting((OCLocalFormatterData)dataStorage).wrap, ret.alignment);
                        }
                        case 1: {
                            return OCFormatterInfo.createInfo(OCWrappingProcessor.getNewLineFormatting((OCLocalFormatterData)dataStorage).wrap, ret.alignment);
                        }
                    }
                    return OCFormatterInfo.createInfo(OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)dataStorage).wrap, ret.alignment);
                }
                return ret;
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.CPP_CONSTRUCTOR_FIELD_INITIALIZER) {
                return OCWrappingProcessor.getJoinFormatting(dataStorage);
            }
        }
        if (this.thisType == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
            OCFormatterInfo ret = this.myData.get((Object)OCElementTypes.CPP_BASE_CLAUSE_LIST, new Computable<OCFormatterInfo>(){

                public OCFormatterInfo compute() {
                    return OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)((OCWrappingProcessor)OCWrappingProcessor.this).myData).wrap, (WrapType)WrapType.byLegacyRepresentation((int)OCWrappingProcessor.this.ocSettings.SUPERCLASS_LIST_WRAP), (boolean)true), (Alignment)(OCWrappingProcessor.this.ocSettings.SUPERCLASS_LIST_ALIGN_MULTILINE ? Alignment.createAlignment() : null));
                }
            });
            if (this.childType == OCTokenTypes.COLON) {
                switch (this.ocSettings.SUPERCLASS_LIST_BEFORE_COLON) {
                    case 0: {
                        return this.getJoinFormatting();
                    }
                    case 1: {
                        return OCWrappingProcessor.getNewLineFormatting(this.myData);
                    }
                }
                return OCWrappingProcessor.getIfLongFormatting(this.myData);
            }
            if (this.shouldAlignAsElementOrComma(OCElementTypes.CPP_BASE_CLAUSE, this.ocSettings.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE)) {
                if (OCFormatterUtil.isPrecededBy(this.childNode, OCTokenTypes.COLON)) {
                    switch (this.ocSettings.SUPERCLASS_LIST_AFTER_COLON) {
                        case 0: {
                            return OCFormatterInfo.createInfo(this.getJoinFormatting().wrap, ret.alignment);
                        }
                        case 1: {
                            return OCFormatterInfo.createInfo(OCWrappingProcessor.getNewLineFormatting((OCLocalFormatterData)this.myData).wrap, ret.alignment);
                        }
                    }
                    return OCFormatterInfo.createInfo(OCWrappingProcessor.getIfLongFormatting((OCLocalFormatterData)this.myData).wrap, ret.alignment);
                }
                return ret;
            }
            if (this.childType == OCTokenTypes.COMMA || this.childType == OCElementTypes.CPP_BASE_CLAUSE) {
                return this.getJoinFormatting();
            }
        }
        if (this.thisType == OCElementTypes.METHOD_SELECTOR_PART && FormatterUtil.isFollowedBy(this.childNode, OCTokenTypes.COLON)) {
            return this.myData.getParent().get(KEY_PARAMETER_COLUMNS, new Computable<OCFormatterInfo>(){

                public OCFormatterInfo compute() {
                    return OCFormatterInfo.createInfo(OCWrappingProcessor.this.ocSettings.METHOD_PARAMETERS_ALIGN_BY_COLONS ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT) : null);
                }
            });
        }
        if (this.childType == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
            this.wrapOnly(KEY_TEMPLATE_DECLARATION_WRAP, this.thisType == OCElementTypes.DECLARATION ? this.ocSettings.TEMPLATE_DECLARATION_STRUCT_WRAP : this.ocSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP, false);
            return this.alignOnly(KEY_TEMPLATE_DECLARATION_WRAP, true);
        }
        if (this.childType == OCElementTypes.MESSAGE_ARGUMENT) {
            boolean isFirstArgument;
            OCFormatterInfo argBasePosition = this.myData.get(KEY_METHOD_FIRST_ARGUMENT);
            if (argBasePosition == null) {
                OCLocalFormatterData topData = this.myData;
                while (topData.getParent().getType() == OCElementTypes.MESSAGE_EXPRESSION) {
                    topData = topData.getParent();
                }
                OCFormatterInfo chainPosition = topData.get(KEY_METHOD_CHAIN, new Computable<OCFormatterInfo>(){

                    public OCFormatterInfo compute() {
                        return OCFormatterInfo.createInfo(Wrap.createWrap((WrapType)WrappingUtil.getWrapType(OCWrappingProcessor.this.settings.METHOD_CALL_CHAIN_WRAP), (boolean)true), Alignment.createAlignment());
                    }
                });
                argBasePosition = this.myData.put(KEY_METHOD_FIRST_ARGUMENT, OCFormatterInfo.createInfo(chainPosition.wrap, (Alignment)(this.settings.ALIGN_MULTILINE_CHAINED_METHODS ? chainPosition.alignment : (this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE ? Alignment.createAlignment() : null))));
            }
            boolean bl = isFirstArgument = !OCFormatterUtil.isPrecededBy(this.childNode, OCElementTypes.MESSAGE_ARGUMENT);
            if (isFirstArgument) {
                boolean inChain = OCFormatterUtil.isPrecededBy(this.childNode, OCElementTypes.MESSAGE_EXPRESSION);
                return inChain ? argBasePosition : OCFormatterInfo.createInfo(null, argBasePosition.alignment);
            }
            final OCFormatterInfo argBasePositionF = argBasePosition;
            return this.myData.get(KEY_METHOD_ARGUMENTS, new Computable<OCFormatterInfo>(){

                public OCFormatterInfo compute() {
                    return OCFormatterInfo.createInfo(Wrap.createChildWrap((Wrap)argBasePositionF.wrap, (WrapType)WrappingUtil.getWrapType(OCWrappingProcessor.this.ocSettings.METHOD_CALL_ARGUMENTS_WRAP), (boolean)true), OCWrappingProcessor.this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE ? Alignment.createChildAlignment((Alignment)argBasePositionF.alignment) : null);
                }
            });
        }
        if (this.childType == CHAINED_CALL_PSEUDOTYPE) {
            return this.wrapAndAlign(this.childType, this.settings.METHOD_CALL_CHAIN_WRAP, this.settings.ALIGN_MULTILINE_CHAINED_METHODS);
        }
        if (this.childType == BINARY_EXPRESSION_PSEUDOTYPE) {
            return this.wrapOnly(this.childType, this.settings.BINARY_OPERATION_WRAP);
        }
        if (this.thisType == OCElementTypes.BINARY_EXPRESSION) {
            return this.alignOnly(this.thisType, this.settings.ALIGN_MULTILINE_BINARY_OPERATION);
        }
        if (OCFormatterUtil.isMessageArgumentValue(this.childNode)) {
            int varArgIndex = -1;
            boolean isDictionaryPairs = false;
            for (ASTNode each = this.thisNode; each != null; each = each.getTreePrev()) {
                if (each.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) continue;
                if (OCFormatterUtil.isVarArgArgument(each)) {
                    ++varArgIndex;
                    continue;
                }
                ASTNode selector = each.findChildByType((IElementType)OCElementTypes.ARGUMENT_SELECTOR);
                if (selector == null || !StringUtil.containsIgnoreCase((String)StringUtil.notNullize((String)selector.getText()), (String)"ObjectsAndKeys")) break;
                isDictionaryPairs = true;
                break;
            }
            OCLocalFormatterData containerData = this.myData.getAncestor(OCElementTypes.MESSAGE_EXPRESSION);
            if (varArgIndex != -1) {
                OCFormatterInfo result2 = containerData.get(KEY_METHOD_ARGUMENT_VALUES);
                if (result2 != null) {
                    if (this.ocSettings.METHOD_CALL_ARGUMENTS_SPECIAL_DICTIONARY_PAIRS_TREATMENT && isDictionaryPairs && varArgIndex % 2 == 0) {
                        return OCFormatterInfo.createInfo(this.ocSettings.ALIGN_DICTIONARY_PAIR_VALUES ? this.pairsGroupAlignment(KEY_GROUP_DICTIONARY_PAIRS, containerData, this.thisNode) : result2.alignment);
                    }
                    return result2;
                }
            } else if (OCFormatterUtil.isFollowedByVarArg(this.thisNode)) {
                OCFormatterInfo arguments = containerData.get(KEY_METHOD_ARGUMENTS);
                OCFormatterInfo formatInfo = OCFormatterInfo.createInfo(arguments != null ? arguments.wrap : Wrap.createWrap((int)this.ocSettings.METHOD_CALL_ARGUMENTS_WRAP, (boolean)true), Alignment.createAlignment());
                return OCFormatterInfo.createInfo(containerData.put((Object)KEY_METHOD_ARGUMENT_VALUES, (OCFormatterInfo)formatInfo).alignment);
            }
            return OCFormatterInfo.EMPTY;
        }
        if (this.thisType == OCElementTypes.ARGUMENT_SELECTOR && FormatterUtil.isFollowedBy(this.childNode, OCTokenTypes.COLON)) {
            return this.myData.getAncestor(OCElementTypes.MESSAGE_EXPRESSION).get(KEY_CALL_ARGUMENT_COLUMNS, new Computable<OCFormatterInfo>(){

                public OCFormatterInfo compute() {
                    return OCFormatterInfo.createInfo(OCWrappingProcessor.this.ocSettings.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS ? Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.RIGHT) : null);
                }
            });
        }
        if (!(this.thisType != OCElementTypes.PARAMETER_LIST && this.thisType != OCElementTypes.ARGUMENT_LIST && this.thisType != OCElementTypes.MACRO_CALL || this.childType != OCTokenTypes.LPAR && this.childType != OCTokenTypes.RPAR)) {
            return this.alignOnly((Object)OCTokenTypes.LPAR, this.thisType == OCElementTypes.PARAMETER_LIST ? this.ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS : this.ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS);
        }
        if (!(this.thisType != OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST && this.thisType != OCElementTypes.TEMPLATE_ARGUMENT_LIST || this.childType != OCTokenTypes.LT && this.childType != OCTokenTypes.GT)) {
            return this.alignOnly((Object)OCTokenTypes.LPAR, this.thisType == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST ? this.ocSettings.TEMPLATE_PARAMETERS_ALIGN_MULTILINE_PARS : this.ocSettings.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS);
        }
        if (this.thisType == OCElementTypes.FOR_STATEMENT && (psi = (OCForStatement)this.thisNode.getPsi(OCForStatement.class)) != null && OCElementUtil.isOneOf(this.childNode, psi.getInitializer(), psi.getCondition(), psi.getIncrement())) {
            return this.wrapAndAlign(this.thisType, this.settings.FOR_STATEMENT_WRAP, this.settings.ALIGN_MULTILINE_FOR);
        }
        if (this.childType == OCElementTypes.ASSIGNMENT_EXPRESSION) {
            result = this.myData.put(KEY_ASSIGNMENT_ALIGNMENT, this.myData.getParent().get(KEY_ASSIGNMENT_ALIGNMENT));
            if (result == null) {
                result = this.alignOnly(KEY_ASSIGNMENT_ALIGNMENT, this.settings.ALIGN_MULTILINE_ASSIGNMENT);
            }
            return result;
        }
        if (this.thisType == OCElementTypes.ASSIGNMENT_EXPRESSION) {
            boolean isEq = this.childType == OCTokenTypes.EQ;
            alignment = null;
            if (isEq) {
                Pair<Object, ASTNode> groupKeyPair = OCWrappingProcessor.getAssignGroupKey(this.thisNode);
                alignment = this.varsGroupAlignment(groupKeyPair.first, (ASTNode)groupKeyPair.second);
            }
            if (this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE == isEq) {
                OCFormatterInfo wrap = this.myData.getParent().get(KEY_ASSIGNMENT_WRAP);
                wrap = wrap == null ? this.wrapOnly(KEY_ASSIGNMENT_WRAP, this.settings.ASSIGNMENT_WRAP, this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) : this.myData.put(KEY_ASSIGNMENT_WRAP, wrap);
                return OCFormatterInfo.createInfo(wrap.wrap, alignment);
            }
            return OCFormatterInfo.createInfo(alignment);
        }
        if ((this.thisType == OCElementTypes.DECLARATION || this.thisType == OCElementTypes.FUNCTION_DECLARATION) && this.childType == OCElementTypes.DECLARATOR) {
            return OCFormatterInfo.createInfo(this.wrapOnly((Object)this.childType, (int)this.settings.ASSIGNMENT_WRAP, (boolean)true).wrap, this.varsGroupAlignment(KEY_GROUP_VARIABLE_NAME, this.childNode));
        }
        if ((this.parentType == OCElementTypes.DECLARATION || this.parentType == OCElementTypes.FUNCTION_DECLARATION) && this.thisType == OCElementTypes.DECLARATOR && OCWrappingProcessor.isOrFollows(this.childNode, OCTokenTypes.IDENTIFIER)) {
            boolean isEq = this.childType == OCTokenTypes.EQ;
            alignment = null;
            if (isEq) {
                Pair<Object, ASTNode> groupKeyPair = OCWrappingProcessor.getAssignGroupKey(this.thisNode);
                alignment = this.varsGroupAlignment(groupKeyPair.first, (ASTNode)groupKeyPair.second);
            }
            if (this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE == isEq) {
                return OCFormatterInfo.createInfo(this.wrapOnly((Object)KEY_ASSIGNMENT_WRAP, (int)this.settings.ASSIGNMENT_WRAP, (boolean)this.settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE).wrap, alignment);
            }
            return OCFormatterInfo.createInfo(alignment);
        }
        if (this.thisType == OCElementTypes.CONDITIONAL_EXPRESSION) {
            boolean needWrap;
            boolean shortTernaryOperator = this.ocSettings.IN_LINE_SHORT_TERNARY_OPERATOR && OCElementUtil.getElementType(FormatterUtil.getNextNonWhitespaceSibling(this.thisNode.findChildByType((IElementType)OCTokenTypes.QUEST))) == OCTokenTypes.COLON;
            boolean isOperator = this.childType == OCTokenTypes.QUEST || this.childType == OCTokenTypes.COLON && !shortTernaryOperator;
            boolean bl = needWrap = isOperator == this.settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && (!shortTernaryOperator || this.childType != OCTokenTypes.COLON);
            return OCFormatterInfo.createInfo(needWrap ? this.wrapOnly((Object)(isOperator ? OCWrappingProcessor.KEY_TERNARY_OPERATOR_WRAP : OCWrappingProcessor.KEY_TERNARY_WRAP), (int)this.settings.TERNARY_OPERATION_WRAP, (boolean)isOperator).wrap : null, this.alignOnly((Object)(isOperator ? OCWrappingProcessor.KEY_TERNARY_OPERATOR_ALIGNMENT : OCWrappingProcessor.KEY_TERNARY_ALIGNMENT), (boolean)this.settings.ALIGN_MULTILINE_TERNARY_OPERATION, (Object)(isOperator ? OCWrappingProcessor.KEY_TERNARY_ALIGNMENT : null)).alignment);
        }
        if (OCFormatterUtil.isCollectionOrStructureInitializer(this.thisType) && this.shouldAlignAsElementOrComma(OCElementTypes.EXPRESSIONS, this.ocSettings.ARRAY_INITIALIZER_COMMA_ON_NEXT_LINE)) {
            if (this.ocSettings.ALIGN_INIT_LIST_IN_COLUMNS && this.isInTableLikeInitList()) {
                return this.findTopInitListData().get(OCWrappingProcessor.getInitListGroupKey(this.childNode), new Computable<OCFormatterInfo>(){

                    public OCFormatterInfo compute() {
                        return OCFormatterInfo.createInfo(Wrap.createWrap((int)(OCWrappingProcessor.this.parentType != OCElementTypes.COMPOUND_INITIALIZER ? 2 : 0), (boolean)false), Alignment.createAlignment((boolean)true));
                    }
                });
            }
            result = this.wrapAndAlign(this.thisType, this.settings.ARRAY_INITIALIZER_WRAP, this.settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION);
            if (this.thisType != OCElementTypes.NS_DICTIONARY_LITERAL || FormatterUtil.isFollowedBy(this.childNode, (IElementType)OCTokenTypes.COLON, this.childType == OCTokenTypes.COMMA ? COMMENTS_OR_EXPRESSION : OCTokenTypes.COMMENTS)) {
                return result;
            }
            return OCFormatterInfo.createInfo(result.alignment);
        }
        if (this.thisType == OCElementTypes.NS_DICTIONARY_LITERAL && this.childType == OCTokenTypes.COLON) {
            return OCFormatterInfo.createInfo(this.pairsGroupAlignment(KEY_GROUP_DICTIONARY_PAIRS, this.myData, this.childNode));
        }
        if (this.thisType == OCElementTypes.ENUM && this.shouldAlignAsElementOrComma(OCElementTypes.DECLARATION, this.ocSettings.ENUM_CONSTANTS_COMMA_ON_NEXT_LINE)) {
            int wrap = this.settings.ENUM_CONSTANTS_WRAP;
            if (this.ocSettings.KEEP_STRUCTURES_IN_ONE_LINE && wrap == 2) {
                wrap = 4;
            }
            return this.wrapOnly((Object)OCElementTypes.ENUM, wrap);
        }
        if (this.thisType == OCElementTypes.PROPERTY && (this.childType == OCElementTypes.DECLARATION || this.childType == OCElementTypes.FUNCTION_DECLARATION)) {
            return this.wrapOnly(this.thisType, this.ocSettings.WRAP_PROPERTY_DECLARATION, true);
        }
        return OCFormatterInfo.createInfo(null, null);
    }

    public static OCFormatterInfo getJoinFormatting(OCLocalFormatterData data) {
        return data.get(KEY_NEVER_WRAP, new Computable<OCFormatterInfo>(){

            public OCFormatterInfo compute() {
                return OCFormatterInfo.createInfo(Wrap.createWrap((int)0, (boolean)true), null);
            }
        });
    }

    public OCFormatterInfo getJoinFormatting() {
        return OCWrappingProcessor.getJoinFormatting(this.myData);
    }

    public static OCFormatterInfo getNewLineFormatting(OCLocalFormatterData data) {
        return data.get(KEY_ALWAYS_WRAP, new Computable<OCFormatterInfo>(){

            public OCFormatterInfo compute() {
                return OCFormatterInfo.createInfo(Wrap.createWrap((int)2, (boolean)true), null);
            }
        });
    }

    public static OCFormatterInfo getIfLongFormatting(OCLocalFormatterData data) {
        return data.get(KEY_IF_LONG_WRAP, new Computable<OCFormatterInfo>(){

            public OCFormatterInfo compute() {
                return OCFormatterInfo.createInfo(Wrap.createWrap((int)5, (boolean)true), null);
            }
        });
    }

    private boolean isInTableLikeInitList() {
        ASTNode topList = null;
        ASTNode nextList = this.thisNode;
        while (OCElementUtil.getElementType(nextList) == OCElementTypes.COMPOUND_INITIALIZER) {
            topList = nextList;
            nextList = nextList.getTreeParent();
        }
        if (topList == null) {
            return false;
        }
        Boolean isTable = (Boolean)topList.getUserData(IS_TABLE);
        if (isTable == null) {
            isTable = OCWrappingProcessor.isInTableLikeInitListReal(topList);
            topList.putUserData(IS_TABLE, (Object)isTable);
        }
        return isTable;
    }

    private static boolean isInTableLikeInitListReal(ASTNode topList) {
        for (ASTNode child = topList.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType cType = child.getElementType();
            if (OCWrappingProcessor.isInessential(child) || cType instanceof OCPunctuatorElementType || cType == OCElementTypes.COMPOUND_INITIALIZER) continue;
            return false;
        }
        return true;
    }

    private OCFormatterInfo wrapOnly(Object key, int wrap) {
        return this.wrapOnly(key, wrap, false);
    }

    private OCFormatterInfo wrapOnly(Object key, int wrapType, boolean wrapFirstElement) {
        return this.wrapAndAlign(key, true, wrapType, wrapFirstElement, null, false, null);
    }

    private OCFormatterInfo alignOnly(Object key, boolean align) {
        return this.alignOnly(key, align, null);
    }

    private OCFormatterInfo alignOnly(Object key, boolean align, Object keyParent) {
        OCFormatterInfo formatInfo;
        Alignment parentAlignment = null;
        if (keyParent != null && (formatInfo = this.myData.get(keyParent)) != null) {
            parentAlignment = formatInfo.alignment;
        }
        return this.wrapAndAlign(key, false, -1, false, null, align, parentAlignment);
    }

    private OCFormatterInfo wrapAndAlign(Object key, int wrapType, boolean align) {
        return this.wrapAndAlign(key, wrapType, false, align);
    }

    private OCFormatterInfo wrapAndAlign(Object key, int wrapType, boolean wrapFirstElement, boolean align) {
        return this.wrapAndAlign(key, true, wrapType, wrapFirstElement, null, align, null);
    }

    private OCFormatterInfo wrapAndAlign(Object key, final boolean wrap, final int wrapType, final boolean wrapFirstElement, final @Nullable Wrap parentWrap, final boolean align, final @Nullable Alignment parentAlignment) {
        return this.myData.get(key, new Computable<OCFormatterInfo>(){

            public OCFormatterInfo compute() {
                Wrap wrapping = wrap ? Wrap.createChildWrap((Wrap)parentWrap, (WrapType)WrappingUtil.getWrapType(wrapType), (boolean)wrapFirstElement) : null;
                Alignment alignment = null;
                if (align) {
                    alignment = parentAlignment != null ? Alignment.createChildAlignment((Alignment)parentAlignment) : Alignment.createAlignment();
                }
                return OCFormatterInfo.createInfo(wrapping, alignment);
            }
        });
    }

    private static boolean isVariableScope(@Nullable IElementType type) {
        return OCWrappingProcessor.isBlock(type) || OCWrappingProcessor.isVariablesListOrStructure(type) || OCWrappingProcessor.isGlobalDeclarationScope(type);
    }

    @Nullable
    private Alignment varsGroupAlignment(@NotNull Object key, @Nullable ASTNode node) {
        if (!this.settings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            return null;
        }
        return this.groupAlignment(this.findVarGroupParentData(), key, node, VARS_ALIGNMENT_CONFIG);
    }

    @Nullable
    private Alignment pairsGroupAlignment(@NotNull Object key, @Nullable OCLocalFormatterData parentData, @Nullable ASTNode node) {
        if (!this.ocSettings.ALIGN_DICTIONARY_PAIR_VALUES) {
            return null;
        }
        return this.groupAlignment(parentData, key, node, null);
    }

    @Nullable
    private Alignment groupAlignment(@Nullable OCLocalFormatterData parentData, @NotNull Object key, @Nullable ASTNode node, @Nullable AlignmentInColumnsConfig config) {
        if (parentData == null) {
            return null;
        }
        Computable<OCFormatterInfo> factory = new Computable<OCFormatterInfo>(){

            public OCFormatterInfo compute() {
                return OCFormatterInfo.createInfo(Alignment.createAlignment((boolean)true));
            }
        };
        if (config != null && AlignmentInColumnsHelper.INSTANCE.useDifferentVarDeclarationAlignment(node, config, this.settings.KEEP_BLANK_LINES_IN_DECLARATIONS)) {
            parentData.put(key, (OCFormatterInfo)factory.compute());
        }
        return parentData.get((Object)key, (Computable<OCFormatterInfo>)factory).alignment;
    }

    @NotNull
    private OCLocalFormatterData findVarGroupParentData() {
        OCLocalFormatterData data = this.myData;
        while (!OCWrappingProcessor.isVariableScope(data.getType()) && !data.isNull()) {
            data = data.getParent();
        }
        return data;
    }

    @NotNull
    private OCLocalFormatterData findTopInitListData() {
        OCLocalFormatterData data = this.myData;
        while (data.getParent().getType() == OCElementTypes.COMPOUND_INITIALIZER) {
            data = data.getParent();
        }
        return data;
    }
}

