/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCFormatterInfo;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.formatting.OCWrappingProcessor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCRecursiveBlockTransformer {
    public static OCRecursiveBlockTransformer CALL_CHAIN_TRANSFORMER = new OCCallChainTransformer();
    public static OCRecursiveBlockTransformer BINARY_CHAIN_TRANSFORMER = new OCBinaryChainTransformer();

    protected abstract boolean needTransformation(@NotNull ASTNode var1);

    protected abstract boolean needCommonWrapper(@NotNull ASTNode var1);

    protected abstract boolean needKeysFromNodeBlock(@NotNull ASTNode var1);

    protected abstract IElementType getAttrPseudotype(@NotNull ASTNode var1);

    protected abstract boolean chainFirst(@NotNull OCWrappingProcessor var1, @NotNull ASTNode var2);

    @NotNull
    protected abstract SplitterType getSplitterType(@NotNull OCWrappingProcessor var1, @NotNull Block var2, @NotNull ASTNode var3);

    protected void splitAndAdd(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> ownerCollector, @NotNull Block nodeBlock, @NotNull List<Block> nodeSubBlocks, @NotNull ASTNode node) {
        IElementType formatterPseudotype = this.getAttrPseudotype(node);
        OCFormatterInfo chainAttr = ownerWrappingCalculator.calculate(node, formatterPseudotype);
        OCFormatterInfo joinAttr = OCFormatterInfo.EMPTY;
        ArrayList<Block> commonWrapperCollector = new ArrayList<Block>();
        ArrayList<Object> wrapperCollector = new ArrayList<Block>();
        boolean inChain = !ownerBlock.isInDirective() && this.chainFirst(ownerWrappingCalculator, node);
        Indent childIndent = Indent.getContinuationWithoutFirstIndent();
        for (Block nodeSubBlock : nodeSubBlocks) {
            SplitterType type = this.getSplitterType(ownerWrappingCalculator, nodeSubBlock, node);
            if (type != SplitterType.BlockNotSplitter) {
                if (type == SplitterType.BlockToLeft) {
                    wrapperCollector.add(nodeSubBlock);
                }
                if (!wrapperCollector.isEmpty()) {
                    OCFormatterInfo attr = inChain ? chainAttr : joinAttr;
                    commonWrapperCollector.add(new OCSimpleBlock(attr.wrap, attr.alignment, childIndent, ownerBlock, wrapperCollector));
                    wrapperCollector = new ArrayList();
                }
                if (type == SplitterType.BlockToRight) {
                    wrapperCollector.add(nodeSubBlock);
                }
                inChain = !ownerBlock.isInDirective();
                continue;
            }
            wrapperCollector.add(nodeSubBlock);
        }
        if (!wrapperCollector.isEmpty()) {
            OCFormatterInfo attr = inChain ? chainAttr : joinAttr;
            commonWrapperCollector.add(new OCSimpleBlock(attr.wrap, attr.alignment, childIndent, ownerBlock, wrapperCollector));
        }
        if (!commonWrapperCollector.isEmpty()) {
            if (!ownerBlock.isInDirective()) {
                this.applyIndentCorrection(commonWrapperCollector, ownerWrappingCalculator);
            }
            ownerCollector.add(new OCSimpleBlock(nodeBlock.getWrap(), nodeBlock.getAlignment(), nodeBlock.getIndent(), ownerBlock, commonWrapperCollector));
        }
        ownerBlock.getLocalFormatterData().put(formatterPseudotype, null);
    }

    protected void applyIndentCorrection(List<Block> collector, OCWrappingProcessor ownerWrappingCalculator) {
    }

    public boolean isTransformed(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> ownerCollector, @NotNull OCCodeBlock nodeBlock, @NotNull ASTNode node) {
        List<Block> nodeSubBlocks;
        if (this.needTransformation(node) && !(nodeSubBlocks = nodeBlock.getSubBlocks()).isEmpty()) {
            if (this.needKeysFromNodeBlock(node)) {
                ownerBlock.getLocalFormatterData().merge(nodeBlock.getLocalFormatterData());
            }
            if (this.needCommonWrapper(node)) {
                this.splitAndAdd(ownerWrappingCalculator, ownerBlock, ownerCollector, (Block)nodeBlock, nodeSubBlocks, node);
            } else {
                ownerCollector.addAll(nodeSubBlocks);
            }
            return true;
        }
        return false;
    }

    public static class OCBinaryChainTransformer
    extends OCRecursiveBlockTransformer {
        @Override
        protected boolean needTransformation(@NotNull ASTNode node) {
            return node.getElementType() == OCElementTypes.BINARY_EXPRESSION;
        }

        @Override
        protected boolean needCommonWrapper(@NotNull ASTNode node) {
            return !ChainOperations.canChain(node, node.getTreeParent());
        }

        @Override
        protected boolean needKeysFromNodeBlock(@NotNull ASTNode node) {
            return !this.needCommonWrapper(node);
        }

        @Override
        protected IElementType getAttrPseudotype(@NotNull ASTNode node) {
            return OCWrappingProcessor.BINARY_EXPRESSION_PSEUDOTYPE;
        }

        @Override
        protected boolean chainFirst(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull ASTNode node) {
            return true;
        }

        @Override
        @NotNull
        protected SplitterType getSplitterType(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull Block nodeSubBlock, @NotNull ASTNode node) {
            if (OCCodeBlock.getBlockType(nodeSubBlock) instanceof OCPunctuatorElementType) {
                return ownerWrappingCalculator.getSettings().BINARY_OPERATION_SIGN_ON_NEXT_LINE ? SplitterType.BlockToRight : SplitterType.BlockToLeft;
            }
            return SplitterType.BlockNotSplitter;
        }

        static class ChainOperations {
            private static TokenSet ADDITIVE = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.PLUS, OCTokenTypes.MINUS});
            private static TokenSet MULTIPLICATIVE = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.MUL, OCTokenTypes.DIV, OCTokenTypes.PERC});
            private static TokenSet BINARY_SHIFT = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LTLT, OCTokenTypes.GTGT});
            private static TokenSet LOGICAL = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LT, OCTokenTypes.GT, OCTokenTypes.LTEQ, OCTokenTypes.GTEQ, OCTokenTypes.EQEQ, OCTokenTypes.EXCLEQ});
            private static TokenSet QUALIFYING = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.DOT_MUL, OCTokenTypes.DEREF_MUL});

            ChainOperations() {
            }

            private static boolean canChain(@Nullable ASTNode node1, @Nullable ASTNode node2) {
                OCElementType type2;
                if (node1 == null || node2 == null) {
                    return false;
                }
                PsiElement psi1 = node1.getPsi();
                PsiElement psi2 = node2.getPsi();
                if (psi1 == null || psi2 == null || !(psi1 instanceof OCBinaryExpression) || !(psi2 instanceof OCBinaryExpression)) {
                    return false;
                }
                OCElementType type1 = ((OCBinaryExpression)psi1).getOperationSign();
                return type1 == (type2 = ((OCBinaryExpression)psi2).getOperationSign()) || ADDITIVE.contains((IElementType)type1) && ADDITIVE.contains((IElementType)type2) || MULTIPLICATIVE.contains((IElementType)type1) && MULTIPLICATIVE.contains((IElementType)type2) || BINARY_SHIFT.contains((IElementType)type1) && BINARY_SHIFT.contains((IElementType)type2) || LOGICAL.contains((IElementType)type1) && LOGICAL.contains((IElementType)type2) || QUALIFYING.contains((IElementType)type1) && QUALIFYING.contains((IElementType)type2);
            }
        }
    }

    protected static class OCCallChainTransformer
    extends OCRecursiveBlockTransformer {
        protected OCCallChainTransformer() {
        }

        @Override
        protected boolean needTransformation(@NotNull ASTNode node) {
            IElementType type = node.getElementType();
            return type == OCElementTypes.QUALIFIED_EXPRESSION || type == OCElementTypes.CALL_EXPRESSION;
        }

        @Override
        protected boolean needCommonWrapper(@NotNull ASTNode node) {
            return !this.needTransformation(node.getTreeParent());
        }

        @Override
        protected boolean needKeysFromNodeBlock(@NotNull ASTNode node) {
            return true;
        }

        @Override
        protected IElementType getAttrPseudotype(@NotNull ASTNode node) {
            return OCWrappingProcessor.CHAINED_CALL_PSEUDOTYPE;
        }

        @Override
        protected boolean chainFirst(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull ASTNode node) {
            return false;
        }

        @Override
        protected void applyIndentCorrection(List<Block> collector, OCWrappingProcessor ownerWrappingCalculator) {
            OCFormatterUtil.applyIndentCorrection(false, collector, ownerWrappingCalculator.getSettings().METHOD_CALL_CHAIN_WRAP, ownerWrappingCalculator.getSettings().KEEP_LINE_BREAKS, new Condition<ASTNode>(){

                public boolean value(ASTNode node) {
                    return OCElementUtil.getElementType(node) == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR;
                }
            });
        }

        @Override
        @NotNull
        protected SplitterType getSplitterType(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull Block nodeSubBlock, @NotNull ASTNode node) {
            return OCCodeBlock.getBlockType(nodeSubBlock) == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR ? SplitterType.BlockToRight : SplitterType.BlockNotSplitter;
        }
    }

    private static enum SplitterType {
        BlockNotSplitter,
        BlockToLeft,
        BlockToRight;

    }
}

