/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.formatting.OCLocalFormatterData;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatterInfo {
    @Nullable
    public final Wrap wrap;
    @Nullable
    public final Alignment alignment;
    @Nullable
    public final Indent indent;
    public static OCFormatterInfo EMPTY = new OCFormatterInfo(null, null, null);

    private OCFormatterInfo(@Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        this.alignment = alignment;
        this.wrap = wrap;
        this.indent = indent;
    }

    @NotNull
    public static OCLocalFormatterData createData(@Nullable OCLocalFormatterData parent, @NotNull IElementType type) {
        return new OCLocalFormatterDataImpl(parent, type);
    }

    @NotNull
    static OCFormatterInfo createInfo(@Nullable Alignment alignment) {
        return OCFormatterInfo.createInfo(null, alignment, null);
    }

    @NotNull
    static OCFormatterInfo createInfo(@Nullable Indent indent) {
        return OCFormatterInfo.createInfo(null, null, indent);
    }

    @NotNull
    static OCFormatterInfo createInfo(@Nullable Wrap wrap, @Nullable Alignment alignment) {
        return OCFormatterInfo.createInfo(wrap, alignment, null);
    }

    @NotNull
    static OCFormatterInfo createInfo(@Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent) {
        return new OCFormatterInfo(wrap, alignment, indent);
    }

    private static class OCLocalFormatterNullParentData
    implements OCLocalFormatterData {
        public static final OCLocalFormatterNullParentData INSTANCE = new OCLocalFormatterNullParentData();

        private OCLocalFormatterNullParentData() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        @Nullable
        public IElementType getType() {
            return null;
        }

        @Override
        @NotNull
        public OCLocalFormatterData getParent() {
            return this;
        }

        @Override
        @NotNull
        public OCLocalFormatterData getAncestor(@NotNull IElementType type) {
            return INSTANCE;
        }

        @Override
        @Nullable
        public OCFormatterInfo get(@NotNull Object key) {
            return EMPTY;
        }

        @Override
        @NotNull
        public OCFormatterInfo get(@NotNull Object key, @NotNull Computable<OCFormatterInfo> factory) {
            return (OCFormatterInfo)factory.compute();
        }

        @Override
        @Nullable
        public OCFormatterInfo put(@NotNull Object key, @Nullable OCFormatterInfo value) {
            return value;
        }

        @Override
        public void merge(@Nullable OCLocalFormatterData data) {
        }
    }

    private static class OCLocalFormatterDataImpl
    implements OCLocalFormatterData {
        @NotNull
        private final OCLocalFormatterData myParent;
        @NotNull
        private final IElementType myContainerType;
        @Nullable
        private Map<Object, OCFormatterInfo> myData;

        public OCLocalFormatterDataImpl(@Nullable OCLocalFormatterData parent, @NotNull IElementType type) {
            this.myContainerType = type;
            this.myParent = parent != null ? parent : OCLocalFormatterNullParentData.INSTANCE;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        @Nullable
        public IElementType getType() {
            return this.myContainerType;
        }

        @Override
        @NotNull
        public OCLocalFormatterData getParent() {
            return this.myParent;
        }

        @Override
        @NotNull
        public OCLocalFormatterData getAncestor(@NotNull IElementType containerType) {
            return this.myParent.getType() == containerType ? this.myParent : (this.myParent.getParent().getType() == containerType ? this.myParent.getParent() : OCLocalFormatterNullParentData.INSTANCE.getAncestor(containerType));
        }

        @Override
        @Nullable
        public OCFormatterInfo get(@NotNull Object key) {
            return this.myData == null ? null : this.myData.get(key);
        }

        @Override
        @NotNull
        public OCFormatterInfo get(@NotNull Object key, @NotNull Computable<OCFormatterInfo> factory) {
            OCFormatterInfo result;
            OCFormatterInfo oCFormatterInfo = result = this.myData == null ? null : this.myData.get(key);
            if (result == null) {
                result = this.put(key, (OCFormatterInfo)factory.compute());
            }
            return result;
        }

        @Override
        @Contract(value="_, null -> null")
        public OCFormatterInfo put(@NotNull Object key, @Nullable OCFormatterInfo value) {
            if (this.myData == null) {
                if (value == null) {
                    return null;
                }
                this.myData = new THashMap();
            }
            if (value == null) {
                this.myData.remove(key);
            } else {
                this.myData.put(key, value);
            }
            return value;
        }

        @Override
        public void merge(@Nullable OCLocalFormatterData data) {
            if (data == null || !(data instanceof OCLocalFormatterDataImpl) || ((OCLocalFormatterDataImpl)data).myData == null) {
                return;
            }
            if (this.myData == null) {
                this.myData = new THashMap(((OCLocalFormatterDataImpl)data).myData);
            } else {
                this.myData.putAll(((OCLocalFormatterDataImpl)data).myData);
            }
        }
    }
}

