/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoFormatTypedHandler
extends TypedActionHandlerBase {
    private final Handler[] HANDLERS = new Handler[]{new MethodColonHandler(), new AdjustLineHandler()};

    public OCAutoFormatTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(final @NotNull Editor editor, final char charTyped, @NotNull DataContext dataContext) {
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
        if (charTyped != ':' && charTyped != '@') {
            return;
        }
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        final CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project2).getCurrentSettings();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(editor.getDocument());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (project2.isDisposed()) {
                    return;
                }
                PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
                if (file2 == null) {
                    return;
                }
                for (Handler each : OCAutoFormatTypedHandler.this.HANDLERS) {
                    if (each.handle(charTyped, file2, editor, settings)) break;
                }
            }
        });
    }

    public static class AdjustLineHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, PsiFile file2, Editor editor, CodeStyleSettings settings) {
            ASTNode caseStatement;
            IElementType parentType;
            ASTNode lineStarter;
            ASTNode maybeVisibility;
            ASTNode typedElement = file2.findElementAt(editor.getCaretModel().getOffset() - 1).getNode();
            switch (charTyped) {
                case '@': {
                    maybeVisibility = typedElement.getTreeParent();
                    lineStarter = typedElement;
                    break;
                }
                case ':': {
                    lineStarter = maybeVisibility = OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(typedElement);
                    break;
                }
                default: {
                    return false;
                }
            }
            ASTNode lineAdjuster = null;
            if (maybeVisibility != null && OCElementUtil.isVisibilityKeyword(maybeVisibility)) {
                lineAdjuster = lineStarter;
            } else if (charTyped == ':' && ((parentType = OCElementUtil.getElementType(caseStatement = typedElement.getTreeParent())) == OCElementTypes.CASE_STATEMENT || parentType == OCElementTypes.LABELED_STATEMENT)) {
                lineAdjuster = caseStatement;
            }
            Project project2 = editor.getProject();
            if (lineAdjuster != null && project2 != null) {
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, lineAdjuster.getStartOffset());
                return true;
            }
            return false;
        }
    }

    public static class MethodColonHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, PsiFile file2, Editor editor, CodeStyleSettings settings) {
            if (charTyped != ':') {
                return false;
            }
            Pair<PsiElement, PsiElement> firstAndCurrent = MethodColonHandler.findFirstAndCurrentSelectors(file2.findElementAt(editor.getCaretModel().getOffset() - 1), (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class));
            if (firstAndCurrent == null) {
                return false;
            }
            PsiElement firstSelector = (PsiElement)firstAndCurrent.first;
            PsiElement currSelector = (PsiElement)firstAndCurrent.second;
            ASTNode prevNode = FormatterUtil.getPreviousNonWhitespaceLeaf(currSelector.getNode());
            if (prevNode == null) {
                return false;
            }
            Document document = editor.getDocument();
            int firstSelectorLine = document.getLineNumber(firstSelector.getTextOffset());
            int currSelectorLine = document.getLineNumber(currSelector.getTextOffset());
            int prevNodeLine = document.getLineNumber(prevNode.getTextRange().getEndOffset());
            if (prevNodeLine == currSelectorLine) {
                return false;
            }
            int firstSelectorLineOffset = document.getLineStartOffset(firstSelectorLine);
            int currSelectorLineOffset = document.getLineStartOffset(currSelectorLine);
            int alignByOffset = firstSelector.getTextRange().getEndOffset() - firstSelectorLineOffset;
            int newLineOffset = Math.max(0, alignByOffset - currSelector.getTextLength());
            String spaces = new IndentInfo(0, newLineOffset, 0).generateNewWhiteSpace(settings.getIndentOptions(file2.getFileType()));
            document.replaceString(currSelectorLineOffset, currSelector.getTextOffset(), (CharSequence)spaces);
            return true;
        }

        @Nullable
        private static Pair<PsiElement, PsiElement> findFirstAndCurrentSelectors(@Nullable PsiElement offsetElement, @NotNull OCCodeStyleSettings settings) {
            if (offsetElement == null || OCElementUtil.getElementType(offsetElement) != OCTokenTypes.COLON) {
                return null;
            }
            PsiElement currentArgument = offsetElement.getParent();
            PsiElement firstArgument = null;
            if (currentArgument instanceof OCArgumentSelector && settings.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS) {
                PsiElement prev = currentArgument.getParent();
                do {
                    if (!((prev = prev.getPrevSibling()) instanceof OCMessageArgument)) continue;
                    firstArgument = PsiTreeUtil.findChildOfType((PsiElement)prev, OCArgumentSelector.class);
                } while (prev != null);
            } else if (currentArgument instanceof OCMethodSelectorPart && settings.METHOD_PARAMETERS_ALIGN_BY_COLONS) {
                PsiElement prev = currentArgument;
                do {
                    if (!((prev = prev.getPrevSibling()) instanceof OCMethodSelectorPart)) continue;
                    firstArgument = prev;
                } while (prev != null);
                firstArgument = MethodColonHandler.getIdentifierFromParameter(firstArgument);
                currentArgument = MethodColonHandler.getIdentifierFromParameter(currentArgument);
            }
            return firstArgument == null || currentArgument == null ? null : Pair.create(firstArgument, (Object)currentArgument);
        }

        @Nullable
        private static PsiElement getIdentifierFromParameter(@Nullable PsiElement param) {
            if (param == null) {
                return null;
            }
            ASTNode identifier = param.getNode().findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
            if (identifier == null || OCElementUtil.getElementType(identifier.getTreeNext()) != OCTokenTypes.COLON) {
                return null;
            }
            return identifier.getPsi();
        }
    }

    private static interface Handler {
        public boolean handle(char var1, PsiFile var2, Editor var3, CodeStyleSettings var4);
    }
}

