/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;

public class OCWhileSurrounder
extends OCStatementSurrounder<OCWhileStatement> {
    @Override
    protected String getStatementTemplate(Project project2, PsiElement context) {
        return "while (a) {\n}";
    }

    @Override
    protected PsiElement getInsertionPlace(OCWhileStatement statement2) {
        return statement2.getBody();
    }

    @Override
    protected TextRange getSelectionRange(OCWhileStatement statement2) {
        OCDeclarationOrExpression condition = statement2.getCondition();
        int offset = condition.getRangeWithMacros().getStartOffset();
        OCChangeUtil.delete(condition);
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "while";
    }
}

