/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.surround.OCBlockExpressionSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCNotExpressionSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCParenthesisSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCaWithCastSurrounder;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class OCExpressionSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new OCParenthesisSurrounder(), new OCNotExpressionSurrounder(), new OCaWithCastSurrounder(), new OCBlockExpressionSurrounder()};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        String text = file2.getText();
        startOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)startOffset, (String)" \t\n");
        OCExpression expr = OCCodeInsightUtil.findExpressionAtRange(file2, startOffset, endOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(endOffset - 1), (String)" \t\n") + 1);
        if (expr == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (expr.getParent() instanceof OCExpressionStatement && TreeUtil.findLastLeaf(expr.getParent().getNode()).getElementType() == OCTokenTypes.SEMICOLON) {
            return PsiElement.EMPTY_ARRAY;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.surroundwith.expression");
        return new PsiElement[]{expr};
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }
}

