/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.spellchecker;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.lexer.OCPrefixStringLiteralLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCSpellCheckerStrategy
extends SpellcheckingStrategy {
    private static final StringLiteralTokenizer STRING_LITERAL_TOKENIZER = new StringLiteralTokenizer();

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof OCMacroForeignLeafElement || element instanceof OCStructLike && !((OCStructLike)element).isDeclaration()) {
            return EMPTY_TOKENIZER;
        }
        IElementType nodeType = OCElementUtil.getElementType(element);
        if (OCTokenTypes.ALL_STRINGS.contains(nodeType)) {
            return STRING_LITERAL_TOKENIZER;
        }
        return super.getTokenizer(element);
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PsiElement> {
        private StringLiteralTokenizer() {
        }

        @Override
        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            TextRange range = element.getTextRange();
            int stopChar = 34;
            OCPrefixStringLiteralLexer lexer = new OCPrefixStringLiteralLexer('\"', OCHighlightingLexer.PREFIX_TYPE, (LexerBase)(OCElementUtil.getElementType(element) == OCTokenTypes.STRING_LITERAL ? OCHighlightingLexer.createStringLiteralLexer('\"', OCTokenTypes.STRING_LITERAL) : OCHighlightingLexer.createRawStringLexer()));
            String elementText = element.getText();
            lexer.start(elementText, 0, range.getEndOffset() - range.getStartOffset());
            StringBuilder sb = new StringBuilder();
            int startOffset = 0;
            while (lexer.getTokenType() != null) {
                IElementType tt = lexer.getTokenType();
                String text = elementText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tt)) {
                    StringLiteralTokenizer.consumeCollectedText(element, consumer, sb, startOffset);
                } else if (tt == OCTokenTypes.STRING_LITERAL) {
                    if (sb.length() == 0) {
                        startOffset = lexer.getTokenStart();
                    }
                    sb.append(text);
                } else {
                    StringLiteralTokenizer.consumeCollectedText(element, consumer, sb, startOffset);
                }
                lexer.advance();
            }
            StringLiteralTokenizer.consumeCollectedText(element, consumer, sb, startOffset);
        }

        private static void consumeCollectedText(@NotNull PsiElement element, @NotNull TokenConsumer consumer, @NotNull StringBuilder sb, int startOffset) {
            if (sb.length() != 0) {
                String textToCheck = sb.toString();
                consumer.consumeToken(element, textToCheck, false, startOffset, TextRange.allOf((String)textToCheck), PlainTextSplitter.getInstance());
                sb.setLength(0);
            }
        }
    }
}

