/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;

public class SwitchExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCSwitchStatement) {
            Document doc = editor.getDocument();
            OCSwitchStatement switchStatement = (OCSwitchStatement)psiElement;
            ASTNode rParenth = switchStatement.getRParenth();
            ASTNode lParenth = switchStatement.getLParenth();
            OCDeclarationOrExpression condition = switchStatement.getExpression();
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(switchStatement.getTextRange().getStartOffset()));
                    OCStatement block = switchStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    doc.replaceString(switchStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"switch ()");
                } else {
                    processor2.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getRangeWithMacros().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

