/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.smartEnter.EnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PlainEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        OCBlockStatement block = PlainEnterProcessor.getControlStatementBlock(editor.getCaretModel().getOffset(), psiElement);
        if (block != null) {
            PsiElement firstElement;
            List<OCStatement> statements = block.getStatements();
            PsiElement psiElement2 = firstElement = statements.size() > 0 ? (PsiElement)statements.get(0) : null;
            if (firstElement == null) {
                firstElement = block.getOpeningBrace();
            }
            editor.getCaretModel().moveToOffset(firstElement != null ? firstElement.getTextRange().getStartOffset() : block.getTextRange().getEndOffset());
        }
        PlainEnterProcessor.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
        return true;
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    @Nullable
    private static OCBlockStatement getControlStatementBlock(int caret, PsiElement element) {
        OCStatement body = null;
        if (element instanceof OCIfStatement) {
            body = ((OCIfStatement)element).getThenBranch();
            if (body == null || caret > body.getTextRange().getEndOffset()) {
                body = ((OCIfStatement)element).getElseBranch();
            }
        } else if (element instanceof OCWhileStatement) {
            body = ((OCWhileStatement)element).getBody();
        } else if (element instanceof OCForStatement) {
            body = ((OCForStatement)element).getBody();
        } else if (element instanceof OCForeachStatement) {
            body = ((OCForeachStatement)element).getBody();
        } else if (element instanceof OCDoWhileStatement) {
            body = ((OCDoWhileStatement)element).getBody();
        }
        return body instanceof OCBlockStatement ? (OCBlockStatement)body : null;
    }
}

