/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.Nullable;

public class MissingForeachBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        OCForeachStatement forStatement = MissingForeachBodyFixer.getForeachStatementParent(psiElement);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        OCStatement body = forStatement.getBody();
        if (body instanceof OCBlockStatement) {
            return;
        }
        if (body != null && MissingForeachBodyFixer.startLine(doc, body) == MissingForeachBodyFixer.startLine(doc, forStatement)) {
            return;
        }
        ASTNode eltToInsertAfter = forStatement.getRParenth();
        String text = "{\n}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement.getNode();
            text = "){\n}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }

    @Nullable
    private static OCForeachStatement getForeachStatementParent(PsiElement psiElement) {
        OCForeachStatement statement2 = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, OCForeachStatement.class);
        if (statement2 == null) {
            return null;
        }
        OCExpression iterated = statement2.getCollectionExpression();
        OCElement parameter = statement2.getVariableExpression();
        return PsiTreeUtil.isAncestor((PsiElement)iterated, (PsiElement)psiElement, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)psiElement, (boolean)false) ? statement2 : null;
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

