/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCParameterList;

public class MissingCatchBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof OCCatchSection)) {
            return;
        }
        OCCatchSection catchSection = (OCCatchSection)psiElement;
        Document doc = editor.getDocument();
        OCBlockStatement body = catchSection.getBody();
        if (body != null && MissingCatchBodyFixer.startLine(doc, body) == MissingCatchBodyFixer.startLine(doc, catchSection)) {
            return;
        }
        OCParameterList paramList = catchSection.getParameters();
        if (paramList == null) {
            return;
        }
        ASTNode rParenth = paramList.getRParenth();
        if (rParenth == null) {
            return;
        }
        doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{\n}");
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

