/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;

public class LiteralFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof LeafElement) {
            if (((LeafElement)psiElement).getElementType() == OCTokenTypes.STRING_LITERAL && !StringUtil.endsWithChar((CharSequence)psiElement.getText(), (char)'\"')) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"");
            } else if (((LeafElement)psiElement).getElementType() == OCTokenTypes.CHARACTER_LITERAL && !StringUtil.endsWithChar((CharSequence)psiElement.getText(), (char)'\'')) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'");
            }
        }
    }
}

