/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;

public class IfConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCIfStatement) {
            Document doc = editor.getDocument();
            OCIfStatement ifStatement = (OCIfStatement)psiElement;
            ASTNode rParen = ifStatement.getRParenth();
            ASTNode lParen = ifStatement.getLParenth();
            OCDeclarationOrExpression condition = ifStatement.getCondition();
            if (condition == null) {
                if (lParen == null || rParen == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(ifStatement.getTextRange().getStartOffset()));
                    OCStatement then2 = ifStatement.getThenBranch();
                    if (then2 != null) {
                        stopOffset = Math.min(stopOffset, then2.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, ifStatement.getTextRange().getEndOffset());
                    doc.replaceString(ifStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"if ()");
                    processor2.registerUnresolvedError(ifStatement.getTextRange().getStartOffset() + "if (".length());
                } else {
                    processor2.registerUnresolvedError(lParen.getTextRange().getEndOffset());
                }
            } else if (rParen == null) {
                doc.insertString(condition.getRangeWithMacros().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

