/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;

public class DoWhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCDoWhileStatement) {
            Document doc = editor.getDocument();
            OCDoWhileStatement stmt = (OCDoWhileStatement)psiElement;
            if (stmt.getBody() == null || !(stmt.getBody() instanceof OCBlockExpression) && stmt.getWhileKeyword() == null) {
                int startOffset = stmt.getTextRange().getStartOffset();
                doc.replaceString(startOffset, startOffset + "do".length(), (CharSequence)"do {\n} while()");
                return;
            }
            if (stmt.getCondition() == null) {
                if (stmt.getWhileKeyword() == null) {
                    int endOffset = stmt.getTextRange().getEndOffset();
                    doc.insertString(endOffset, (CharSequence)"while()");
                } else if (stmt.getLParenth() == null || stmt.getRParenth() == null) {
                    TextRange whileRange = stmt.getWhileKeyword().getTextRange();
                    doc.replaceString(whileRange.getStartOffset(), whileRange.getEndOffset(), (CharSequence)"while()");
                } else {
                    processor2.registerUnresolvedError(stmt.getLParenth().getTextRange().getEndOffset());
                }
            }
        }
    }
}

