/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.editor.smartEnter.EnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;

public class CommentBreakerEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        if (isModified) {
            return false;
        }
        PsiElement atCaret = psiElement.getContainingFile().findElementAt(editor.getCaretModel().getOffset());
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)atCaret, PsiComment.class, (boolean)false);
        if (comment != null) {
            CommentBreakerEnterProcessor.plainEnter(editor);
            if (comment.getTokenType() == OCTokenTypes.EOL_COMMENT) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"// ");
            }
            return true;
        }
        return false;
    }

    private static void plainEnter(Editor editor) {
        CommentBreakerEnterProcessor.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }
}

