/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import java.util.List;

public class BlockBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCBlockStatement && this.afterUnmatchedBrace(editor, psiElement.getContainingFile().getFileType())) {
            OCBlockStatement block = (OCBlockStatement)psiElement;
            int stopOffset = block.getTextRange().getEndOffset();
            List<OCStatement> statements = block.getStatements();
            if (statements.size() > 0) {
                stopOffset = statements.get(0).getTextRange().getEndOffset();
            }
            editor.getDocument().insertString(stopOffset, (CharSequence)"}");
        }
    }

    private boolean afterUnmatchedBrace(Editor editor, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, editor.getCaretModel().getOffset(), fileType);
    }
}

