/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCSelectorWordSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return OCSelectorWordSelectioner.selector(e) != null || OCSelectorWordSelectioner.isDirectiveContent(e) || e instanceof OCDefineDirective;
    }

    public static boolean isDirectiveContent(PsiElement e) {
        IElementType tt = e.getNode().getElementType();
        return tt == OCTokenTypes.DIRECTIVE_CONTENT || tt == OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT || tt == OCTokenTypes.CODE_DIRECTIVE_CONTENT;
    }

    @Nullable
    private static OCSelectorExpression selector(PsiElement e) {
        return (OCSelectorExpression)PsiTreeUtil.getParentOfType((PsiElement)e, OCSelectorExpression.class);
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        OCSelectorExpression selector = OCSelectorWordSelectioner.selector(e);
        if (selector != null) {
            return Collections.singletonList(selector.getSelectorRange().shiftRight(selector.getTextRange().getStartOffset()));
        }
        if (OCSelectorWordSelectioner.isDirectiveContent(e)) {
            String text = e.getText();
            int nonws = CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t\n");
            text = text.substring(nonws);
            ArrayList answer = ContainerUtil.newArrayList();
            TextRange baseRange = TextRange.from((int)(e.getTextRange().getStartOffset() + nonws), (int)(e.getTextLength() - nonws));
            answer.add(baseRange);
            SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editorText, cursorOffset, answer);
            if (baseRange.getLength() > 1 && text.startsWith("\"") && text.endsWith("\"") || text.startsWith("<") && text.endsWith(">")) {
                answer.add(baseRange.shiftRight(1).grown(-2));
            }
            return answer;
        }
        if (e instanceof OCDefineDirective) {
            OCMacroParameterList params = ((OCDefineDirective)e).getMacroParameters();
            PsiElement name = ((OCDefineDirective)e).getNameIdentifier();
            if (name != null && params != null) {
                int definitionStart = CharArrayUtil.shiftForward((CharSequence)editorText, (int)params.getTextRange().getEndOffset(), (String)" \t");
                ArrayList answer = ContainerUtil.newArrayList();
                answer.add(TextRange.create((int)name.getTextRange().getStartOffset(), (int)params.getTextRange().getEndOffset()));
                answer.add(TextRange.create((int)definitionStart, (int)e.getTextRange().getEndOffset()));
                return answer;
            }
        }
        return Collections.emptyList();
    }
}

