/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import java.util.ArrayList;
import java.util.List;

public class OCCodeBlockSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof OCBlockStatement;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement lbrace = ((OCBlockStatement)e).getOpeningBrace();
        PsiElement rBrace = ((OCBlockStatement)e).getClosingBrace();
        if (lbrace == null || rBrace == null) {
            return result;
        }
        PsiElement cur = lbrace.getNextSibling();
        while (cur instanceof PsiWhiteSpace) {
            cur = cur.getNextSibling();
        }
        if (cur == null) {
            return result;
        }
        int start = cur.getTextRange().getStartOffset();
        cur = rBrace.getPrevSibling();
        while (cur instanceof PsiWhiteSpace) {
            cur = cur.getPrevSibling();
        }
        if (cur == null) {
            return result;
        }
        int end = cur.getTextRange().getEndOffset();
        if (start >= end) {
            return result;
        }
        result.add(e.getTextRange());
        result.addAll(OCCodeBlockSelectioner.expandToWholeLine(editorText, new TextRange(start, end)));
        return result;
    }
}

