/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectWithFunctionsMacro
extends Macro {
    public static final String MACRO_NAME = "objectWithFunctions";
    private static final Key<Map<String, List<OCDeclaratorSymbol>>> MACRO_LAST_RESULT_KEY = Key.create((String)"objectWithFunctions");

    public String getName() {
        return MACRO_NAME;
    }

    public String getPresentableName() {
        return "objectWithFunctions(...)";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        List<OCDeclaratorSymbol> variables = ObjectWithFunctionsMacro.getVariablesWithMethods(context, OCTemplatesUtil.getStringsList(params, context));
        if (variables.isEmpty()) {
            return null;
        }
        for (OCDeclaratorSymbol var : variables) {
            OCElement def = (OCElement)var.locateDefinition();
            if (def == null) continue;
            return new OCElementResult(def);
        }
        return null;
    }

    @Nullable
    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        List<OCDeclaratorSymbol> variables = ObjectWithFunctionsMacro.getVariablesWithMethods(context, OCTemplatesUtil.getStringsList(params, context));
        if (variables.size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.size()];
        int i = 0;
        for (OCDeclaratorSymbol var : variables) {
            items[i++] = LookupElementBuilder.create((String)var.getName()).withIcon(var.getIcon());
        }
        return items;
    }

    @NotNull
    private static List<OCDeclaratorSymbol> getVariablesWithMethods(@NotNull ExpressionContext context, List<String> requiredMethods) {
        String key;
        List<OCDeclaratorSymbol> results;
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        Map searchCache = (Map)MACRO_LAST_RESULT_KEY.get((UserDataHolder)place);
        if (searchCache == null) {
            searchCache = new HashMap();
            MACRO_LAST_RESULT_KEY.set((UserDataHolder)place, (Object)searchCache);
        }
        if ((results = (List<OCDeclaratorSymbol>)searchCache.get(key = Arrays.toString(requiredMethods.toArray()))) != null) {
            return results;
        }
        results = OCTemplatesUtil.getVariablesWithMethods(context, requiredMethods);
        searchCache.put(key, results);
        return results;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

