/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPObjectWithBeginEndMacro
extends Macro {
    public static final String MACRO_NAME = "variableForRangeBasedIteration";

    public String getName() {
        return MACRO_NAME;
    }

    public String getPresentableName() {
        return "variableForRangeBasedIteration()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesWithBeginEnd(context);
        if (variables.isEmpty()) {
            return null;
        }
        for (OCDeclaratorSymbol var : variables) {
            OCElement def = (OCElement)var.locateDefinition();
            if (def == null) continue;
            return new OCElementResult(def);
        }
        return null;
    }

    @Nullable
    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesWithBeginEnd(context);
        if (variables.size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.size()];
        int i = 0;
        for (OCDeclaratorSymbol var : variables) {
            items[i++] = LookupElementBuilder.create((String)var.getName()).withIcon(var.getIcon());
        }
        return items;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

