/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class TemplateInsertHandler
implements InsertHandler<LookupElement> {
    private final String myInsertion;

    private TemplateInsertHandler(String insertion) {
        this.myInsertion = insertion;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        char currentChar;
        Document document = context.getDocument();
        Editor editor = context.getEditor();
        String insertion = TemplateInsertHandler.preprocessInsertion(context, this.myInsertion);
        char c = currentChar = context.getTailOffset() < document.getTextLength() ? document.getCharsSequence().charAt(context.getTailOffset()) : (char)'\u0000';
        if (insertion.endsWith(" ") && context.getCompletionChar() != ' ' && (currentChar == ')' || currentChar == ' ' || currentChar == '\t')) {
            insertion = insertion.trim();
        }
        int tailOffset = context.getStartOffset() + insertion.length();
        String caretToken = "<caret>";
        int caretOffset = insertion.indexOf(caretToken);
        if (caretOffset != -1) {
            insertion = insertion.substring(0, caretOffset) + insertion.substring(caretOffset + caretToken.length(), insertion.length());
            tailOffset = context.getStartOffset() + caretOffset;
        } else if (!Character.isWhitespace(currentChar) && !Character.isUnicodeIdentifierPart(currentChar) && insertion.endsWith(Character.toString(currentChar))) {
            insertion = insertion.substring(0, insertion.length() - 1);
        }
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
        context.setTailOffset(tailOffset);
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance(context.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document.getText();
        int firstParamStart = documentText.indexOf("<#", context.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        if (!insertion.endsWith(" ")) {
            OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getStartOffset() + insertion.length());
        }
        if (firstParamStart >= 0 && firstParamEnd >= 0 && selectionModel.hasSelection()) {
            editor.getCaretModel().moveToOffset(selectionModel.getSelectionStart());
        } else {
            int toOffset = context.getTailOffset();
            editor.getCaretModel().moveToOffset(toOffset);
            if (toOffset > 0 && editor.getDocument().getCharsSequence().charAt(toOffset - 1) == '\n') {
                CodeStyleManager.getInstance((Project)context.getProject()).adjustLineIndent(editor.getDocument(), toOffset);
            }
        }
        if (context.getCompletionChar() == ' ') {
            context.setAddCompletionChar(false);
        }
    }

    private static String preprocessInsertion(InsertionContext context, String insertion) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
        CommonCodeStyleSettings common = settings.getCommonSettings((Language)OCLanguage.getInstance());
        OCCodeStyleSettings custom = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.FOR_KEYWORD, common.SPACE_BEFORE_FOR_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.IF_KEYWORD, common.SPACE_BEFORE_IF_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.WHILE_KEYWORD, common.SPACE_BEFORE_WHILE_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.SWITCH_KEYWORD, common.SPACE_BEFORE_SWITCH_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.CATCH_KEYWORD, common.SPACE_BEFORE_CATCH_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.FINALLY_KEYWORD, common.SPACE_BEFORE_FINALLY_KEYWORD);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.SYNCHRONIZED_KEYWORD, common.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.PROPERTY_KEYWORD, custom.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES);
        return insertion;
    }

    private static String checkKeyword(String insertion, OCElementType keyword, boolean space) {
        if (insertion.equals(keyword.getName())) {
            return space ? keyword.getName() + " " : keyword.getName();
        }
        return insertion;
    }

    public static LookupElementBuilder lookup(String template) {
        String data = template.replaceAll("\\n|(<caret>)|(<#(.*)#>)", "").trim();
        return TemplateInsertHandler.lookup(data, template);
    }

    public static LookupElementBuilder lookup(String userString, String template) {
        return LookupElementBuilder.create((Object)new TemplateObject(userString), (String)userString).withInsertHandler((InsertHandler)new TemplateInsertHandler(template));
    }

    public static class TemplateObject {
        @NotNull
        private String myData;

        public TemplateObject(@NotNull String data) {
            this.myData = data;
        }

        public String toString() {
            return this.myData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateObject object = (TemplateObject)o;
            return this.myData.equals(object.myData);
        }

        public int hashCode() {
            return this.myData.hashCode();
        }
    }
}

