/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QualifiedSelectorCompletionContributor
extends OCCompletionContributorBase {
    public QualifiedSelectorCompletionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withParent(OCQualifiedExpression.class), new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                OCQualifiedExpression expr = (OCQualifiedExpression)parameters.getPosition().getParent();
                OCObjectTypeContext typeContext = expr.getQualifier().getTypeContext();
                int invocationCount = 0;
                for (OCPunctuatorElementType qt : expr.qualifyingTokensForCompletion()) {
                    int ic = this.addCompletions(qt, parameters, result, expr, typeContext);
                    invocationCount = Math.min(invocationCount, ic);
                }
                if (typeContext != null && invocationCount <= 1) {
                    result.addLookupAdvertisement("Press " + QualifiedSelectorCompletionContributor.getActionShortcut((String)"SmartTypeCompletion") + " to filter results by type");
                    result.addLookupAdvertisement("Press " + QualifiedSelectorCompletionContributor.getActionShortcut((String)"CodeCompletion") + (invocationCount == 0 ? "" : " again") + " for symbols from NSObject categories");
                }
            }

            private int addCompletions(@NotNull OCPunctuatorElementType qualifyingToken, final @NotNull OCCompletionParameters parameters, CompletionResultSet result, OCQualifiedExpression expr, OCObjectTypeContext typeContext) {
                int i;
                CommonProcessors.CollectProcessor<OCSymbol> symbols = new CommonProcessors.CollectProcessor<OCSymbol>(){
                    private Set<String> names = new HashSet<String>();

                    public boolean process(OCSymbol symbol) {
                        OCFile file2;
                        PsiElement fragmentContext;
                        if (symbol.getKind().isType() || symbol.isUnnamed()) {
                            return true;
                        }
                        PsiFile original = parameters.getOriginalFile();
                        if (original instanceof OCCodeFragment && (fragmentContext = original.getContext()) != null) {
                            original = fragmentContext.getContainingFile().getOriginalFile();
                        }
                        if (!(original instanceof OCFile && OCFileSymbols.isSymbolImported((OCFile)original, symbol) || (file2 = symbol.getContainingOCFile()) == null || file2.isHeader())) {
                            return true;
                        }
                        if (this.names.add(symbol.getSignature())) {
                            return super.process((Object)symbol);
                        }
                        return true;
                    }
                };
                OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)symbols, (Condition<T>[])new Condition[]{new Condition<OCSymbol>(){

                    public boolean value(OCSymbol symbol) {
                        return symbol.getKind() == OCSymbolKind.PROPERTY;
                    }
                }, new Condition<OCSymbol>(){

                    public boolean value(OCSymbol symbol) {
                        return symbol instanceof OCMethodSymbol && symbol.isPredeclaration();
                    }
                }, new Condition<OCSymbol>(){

                    public boolean value(OCSymbol symbol) {
                        return symbol.getKind().isFunction();
                    }
                }, new Condition<OCSymbol>(){

                    public boolean value(OCSymbol symbol) {
                        return !symbol.getKind().isConstructorOrDestructor();
                    }
                }, OCSymbol.NON_FANTOM_SYMBOL_CONDITION});
                Ref qualifierType = new Ref();
                expr.processTargets(null, orderedProcessor, false, qualifyingToken, false, true, (Ref<OCType>)qualifierType);
                orderedProcessor.finish();
                if (qualifierType.isNull()) {
                    qualifierType.set((Object)expr.getQualifier().getResolvedType());
                }
                for (i = parameters.getInvocationCount(); i <= 2; ++i) {
                    boolean isEmpty = true;
                    for (OCSymbol symbol : symbols.getResults()) {
                        boolean isFromCurClass = false;
                        if (symbol instanceof OCMemberSymbol) {
                            OCClassSymbol parent = (OCClassSymbol)((OCMemberSymbol)symbol).getParent();
                            if (i <= 1 && "NSObject".equals(parent.getName()) && parent.getCategoryName() != null) continue;
                            boolean bl = isFromCurClass = typeContext != null && Comparing.equal((String)parent.getName(), (String)typeContext.getType().getClassName());
                        }
                        if (symbol.isUnavailable() || symbol.isForbiddenByARC(expr) || i <= 1 && !OCVisibility.isVisible(symbol, expr, (OCType)qualifierType.get()) || symbol instanceof OCMethodSymbol && symbol.isSynthetic() && (!(symbol instanceof OCMethodSymbol) || !((OCMethodSymbol)symbol).isAccessorWithAliasedName())) continue;
                        LookupElement lookup = SymbolLookupBuilderUtil.lookup(symbol, null, typeContext != null ? typeContext.getType() : null, expr, isFromCurClass, null);
                        if (!result.getPrefixMatcher().prefixMatches(lookup)) continue;
                        result.addElement(lookup);
                        OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.set((UserDataHolder)lookup, (Object)qualifyingToken);
                        isEmpty = false;
                    }
                    if (!isEmpty) break;
                }
                return i;
            }
        });
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof OCQualifiedExpression) {
            OCQualifiedExpression expr = (OCQualifiedExpression)parent;
            OCType resolve = expr.getQualifier().getType().resolve(expr.getContainingOCFile());
            if (resolve.getTerminalType() instanceof OCObjectType) {
                return "No suggestions for properties of class " + resolve.getTerminalType().getName(expr);
            }
            return "No suggestions for members of " + resolve.getName(expr);
        }
        return super.handleEmptyLookup(parameters, editor);
    }
}

