/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.util.NullableFunction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;

public class OCSymbolSameDirectoryProximityWeigher
extends Weigher<OCSymbol, ProximityLocation> {
    private static final NullableLazyKey<VirtualFile, ProximityLocation> PLACE_DIRECTORY = NullableLazyKey.create((String)"placeDirectory", (NullableFunction)new NullableFunction<ProximityLocation, VirtualFile>(){

        public VirtualFile fun(ProximityLocation location) {
            PsiElement position = location.getPosition();
            assert (position != null);
            return position.getContainingFile().getOriginalFile().getVirtualFile().getParent();
        }
    });

    public Comparable weigh(@NotNull OCSymbol element, @NotNull ProximityLocation location) {
        if (location.getPosition() == null) {
            return null;
        }
        VirtualFile placeDirectory = (VirtualFile)PLACE_DIRECTORY.getValue((UserDataHolder)location);
        VirtualFile itemFile = element.getContainingFile();
        return Boolean.valueOf(placeDirectory != null && itemFile != null ? placeDirectory.equals(itemFile.getParent()) : false);
    }
}

