/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReferenceContributor;
import org.jetbrains.annotations.NotNull;

public class OCResourceCompletionContributor
extends OCCompletionContributorBase {
    public OCResourceCompletionContributor() {
        OCCompletionProvider provider = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, final CompletionResultSet result) {
                String customPrefix;
                PsiElement expression;
                PsiElement element = parameters.getRealPosition().getParent();
                if (element instanceof OCReferenceElement) {
                    expression = element.getParent();
                    customPrefix = null;
                } else if (element instanceof OCLiteralExpression && ((OCLiteralExpression)element).getTextWithMacros().startsWith("@\"")) {
                    expression = element;
                    customPrefix = parameters.getOffset() > element.getTextOffset() ? ((OCLiteralExpression)element).getTextWithMacros().substring(2, parameters.getOffset() - element.getTextOffset()) : null;
                } else {
                    expression = null;
                    customPrefix = null;
                }
                if (expression != null) {
                    OCResourceReferenceContributor.processReferenceProviders(new Processor<OCResourceCompletionProvider>(){

                        public boolean process(OCResourceCompletionProvider provider) {
                            for (PsiReference reference : provider.getReferencesByElement(expression, new ProcessingContext())) {
                                for (LookupElement variant : ((OCResourceReference)reference).getLookupElements(customPrefix == null)) {
                                    (customPrefix != null ? result.withPrefixMatcher(customPrefix) : result).addElement(variant);
                                }
                            }
                            return true;
                        }
                    });
                }
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT, provider);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.LITERAL_EXPRESSION, provider);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT, provider);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.LITERAL_EXPRESSION, provider);
    }
}

