/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCMethodImplementationCompletionContributor
extends OCCompletionContributorBase {
    public static final ElementPattern<PsiElement> SELECTOR_PART_DECLARATION = PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(OCMethodSelectorPart.class);

    public OCMethodImplementationCompletionContributor() {
        OCCompletionProvider provider = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                PsiElement selector = parameters.getPosition().getParent();
                if (selector instanceof OCMethodSelectorPart) {
                    OCMethod method = (OCMethod)selector.getParent();
                    StringBuilder exactSelectorPrefixBuilder = new StringBuilder();
                    for (OCMethodSelectorPart arg : method.getParameters()) {
                        if (arg == selector) break;
                        exactSelectorPrefixBuilder.append(arg.getSelectorPart());
                    }
                    String exactSelectorPrefix = exactSelectorPrefixBuilder.toString();
                    PsiElement parent = method.getParent();
                    if (parent instanceof OCImplementation) {
                        OCTypeElement typeElement;
                        OCImplementation impl = (OCImplementation)parent;
                        OCImplementationSymbol implementationSymbol = impl.getSymbol();
                        OCObjectType type = impl.getType();
                        if (type == null) {
                            return;
                        }
                        OCObjectTypeContext receiverContext = new OCObjectTypeContext(!method.isInstanceMethod(), true, type, null);
                        final HashSet implemented = new HashSet();
                        if (implementationSymbol != null) {
                            implementationSymbol.processMembers((String)null, new Processor<OCMemberSymbol>(){

                                public boolean process(OCMemberSymbol symbol) {
                                    implemented.add(symbol.getSignature());
                                    return true;
                                }
                            });
                        }
                        Condition<OCMethodSymbol> condition = new Condition<OCMethodSymbol>(){

                            public boolean value(OCMethodSymbol symbol) {
                                return !implemented.contains(symbol.getSignature());
                            }
                        };
                        if (parameters.getCompletionType() == CompletionType.SMART && (typeElement = method.getReturnTypeElement()) != null) {
                            OCFile file2 = method.getContainingOCFile();
                            OCType expectedType = typeElement.getType().resolve(file2);
                            if (expectedType != OCUnknownType.INSTANCE) {
                                condition = Conditions.and((Condition)condition, new OCSmartCompletionContributor.TypeMatchingCondition(file2, selector, expectedType, false, null));
                            }
                        }
                        MethodSelectorCompletionContributor.Context ctx = new MethodSelectorCompletionContributor.Context(exactSelectorPrefix, null, receiverContext, condition);
                        OCMethodImplementationCompletionContributor.doAddCompletions(result, parameters, false, ctx);
                    }
                }
            }
        };
        this.register(CompletionType.BASIC, SELECTOR_PART_DECLARATION, provider);
        this.register(CompletionType.SMART, SELECTOR_PART_DECLARATION, provider);
    }

    private static int doAddCompletions(CompletionResultSet result, OCCompletionParameters parameters, boolean avoidNSObjectMethods, MethodSelectorCompletionContributor.Context context) {
        OCType nsobject;
        int[] addedCnt = new int[]{0};
        Processor<OCMethodSymbol> processor2 = MethodSelectorCompletionContributor.getProcessor(parameters, result, addedCnt, context);
        context.getReceiverContext().getType().processMembers(OCMethodSymbol.class, processor2);
        if (!avoidNSObjectMethods && (nsobject = OCReferenceType.fromText("NSObject").resolve(parameters.getOriginalFile())) instanceof OCObjectType) {
            ((OCObjectType)nsobject).processMembers(OCMethodSymbol.class, processor2);
        }
        return addedCnt[0];
    }
}

