/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCodeContextType
extends TemplateContextType {
    @NotNull
    protected final OCLanguageKind myNeedKind;

    protected OCCodeContextType(@NotNull OCLanguageKind needKind, @NotNull @NonNls String id, @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        super(id, presentableName, baseContextType);
        this.myNeedKind = needKind;
    }

    public boolean isInContext(@NotNull PsiFile file2, int offset) {
        OCLanguageKind fileKind;
        OCLanguageKind oCLanguageKind = fileKind = file2 instanceof OCFile ? ((OCFile)file2).getKind() : null;
        if (fileKind != null && fileKind.conforms(this.myNeedKind)) {
            PsiElement element = file2.findElementAt(offset);
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected boolean isInContext(@NotNull PsiElement element) {
        return true;
    }

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new OCFileHighlighter(this.myNeedKind, false);
    }

    private static class LanguageInfo {
        private static final Map<OCLanguageKind, LanguageInfo> LANGUAGE_INFO = new HashMap<OCLanguageKind, LanguageInfo>(3);
        @NotNull
        @NonNls
        private final String languageContextName;
        @NotNull
        private final String languageSuffixName;
        @NotNull
        private final Class<? extends LanguageBase> baseContextType;

        private LanguageInfo(@NotNull @NonNls String context, @NotNull String suffix, @NotNull Class<? extends LanguageBase> baseClass) {
            this.languageContextName = context;
            this.languageSuffixName = suffix;
            this.baseContextType = baseClass;
        }

        @NotNull
        @NonNls
        public static String getContextName(@NotNull OCLanguageKind kind) {
            return LanguageInfo.LANGUAGE_INFO.get((Object)kind).languageContextName;
        }

        @NotNull
        public static String getSuffix(@NotNull OCLanguageKind kind) {
            return LanguageInfo.LANGUAGE_INFO.get((Object)kind).languageSuffixName;
        }

        @NotNull
        public static Class<? extends LanguageBase> getBaseContext(@NotNull OCLanguageKind kind) {
            return LanguageInfo.LANGUAGE_INFO.get((Object)kind).baseContextType;
        }

        static {
            LANGUAGE_INFO.put(OCLanguageKind.C, new LanguageInfo("c", "_C", LanguageC.class));
            LANGUAGE_INFO.put(OCLanguageKind.CPP, new LanguageInfo("cpp", "_CPP", LanguageCPP.class));
            LANGUAGE_INFO.put(OCLanguageKind.OBJ_C, new LanguageInfo("objc", "", LanguageObjC.class));
        }
    }

    public static class DeclarationC
    extends DeclarationBase {
        public DeclarationC() {
            super(OCLanguageKind.C);
        }
    }

    public static class DeclarationCPP
    extends DeclarationBase {
        public DeclarationCPP() {
            super(OCLanguageKind.CPP);
        }
    }

    public static class DeclarationObjC
    extends DeclarationBase {
        public DeclarationObjC() {
            super(OCLanguageKind.OBJ_C);
        }
    }

    public static class DeclarationBase
    extends OCCodeContextType {
        public DeclarationBase(@NotNull OCLanguageKind needKind) {
            super(needKind, "OC_DECLARATION" + LanguageInfo.getSuffix(needKind), "Declaration", LanguageInfo.getBaseContext(needKind));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class) == null;
        }
    }

    public static class ExpressionC
    extends ExpressionBase {
        public ExpressionC() {
            super(OCLanguageKind.C);
        }
    }

    public static class ExpressionCPP
    extends ExpressionBase {
        public ExpressionCPP() {
            super(OCLanguageKind.CPP);
        }
    }

    public static class ExpressionObjC
    extends ExpressionBase {
        public ExpressionObjC() {
            super(OCLanguageKind.OBJ_C);
        }
    }

    public static class ExpressionBase
    extends OCCodeContextType {
        public ExpressionBase(@NotNull OCLanguageKind needKind) {
            super(needKind, "OC_EXPRESSION" + LanguageInfo.getSuffix(needKind), "Expression", LanguageInfo.getBaseContext(needKind));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return ExpressionBase.isExpressionContext(element);
        }

        private static boolean isExpressionContext(PsiElement element) {
            if (!((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.andNot(OCCompletionPatterns.AFTER_DOT)).accepts((Object)element) && !((PsiElementPattern.Capture)OCCompletionPatterns.TYPE_IN_DECLARATION.andNot(OCCompletionPatterns.AFTER_DOT)).accepts((Object)element)) {
                return false;
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, OCExpression.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarationStatement.class) != null;
        }
    }

    public static class StatementC
    extends StatementBase {
        public StatementC() {
            super(OCLanguageKind.C);
        }
    }

    public static class StatementCPP
    extends StatementBase {
        public StatementCPP() {
            super(OCLanguageKind.CPP);
        }
    }

    public static class StatementObjC
    extends StatementBase {
        public StatementObjC() {
            super(OCLanguageKind.OBJ_C);
        }
    }

    public static class StatementBase
    extends OCCodeContextType {
        public StatementBase(@NotNull OCLanguageKind needKind) {
            super(needKind, "OC_STATEMENT" + LanguageInfo.getSuffix(needKind), "Statement", LanguageInfo.getBaseContext(needKind));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return StatementBase.isStatementContext(element);
        }

        private static boolean isStatementContext(PsiElement element) {
            if (!ExpressionBase.isExpressionContext(element)) {
                return false;
            }
            if (OCCompletionPatterns.AT_STATEMENT_LEVEL.accepts((Object)element)) {
                return true;
            }
            OCExpressionStatement expressionStatement = (OCExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCExpressionStatement.class, (boolean)true);
            return expressionStatement != null && TreeUtil.findFirstLeaf(expressionStatement.getNode()) == element.getNode();
        }
    }

    public static class LanguageC
    extends LanguageBase {
        public LanguageC() {
            super(OCLanguageKind.C);
        }
    }

    public static class LanguageCPP
    extends LanguageBase {
        public LanguageCPP() {
            super(OCLanguageKind.CPP);
        }
    }

    public static class LanguageObjC
    extends LanguageBase {
        public LanguageObjC() {
            super(OCLanguageKind.OBJ_C);
        }
    }

    public static class LanguageBase
    extends OCCodeContextType {
        public LanguageBase(@NotNull OCLanguageKind needKind) {
            super(needKind, LanguageInfo.getContextName(needKind), needKind.getDisplayName(), EverywhereContextType.class);
        }
    }
}

