/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;
    @Nullable
    private PsiElement myContextExpression;

    FunctionInsertHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression) {
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
    }

    public static void changeQualifyingTokenIfNeeded(InsertionContext context, PsiElement contextExpression, LookupElement item) {
        if (contextExpression instanceof OCQualifiedExpression) {
            UsageTrigger.trigger("cidr.completion.qualified");
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)contextExpression;
            OCPunctuatorElementType actualToken = qualifiedExpression.getQualifyingTokenKind();
            OCPunctuatorElementType completionToken = (OCPunctuatorElementType)((Object)OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.get((UserDataHolder)item));
            if (!qualifiedExpression.canChangeQualifyingToken() || completionToken == null || completionToken == actualToken) {
                return;
            }
            Document document = context.getDocument();
            OCElement qualifyingElement = qualifiedExpression.getQualifyingElement();
            TextRange range = OCElementUtil.getUserVisibleRangeInDocument(qualifyingElement);
            if (range != null) {
                UsageTrigger.trigger("cidr.completion.qualified.changeQualifyingToken." + (actualToken == OCTokenTypes.DOT ? "fromDot" : "fromDereference"));
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)completionToken.getName());
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            }
        }
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        if (FunctionInsertHandler.isUsedAsAName(this.mySymbol, this.myContextExpression)) {
            return;
        }
        boolean hasParams = !this.mySymbol.getParameterSymbols().isEmpty();
        CallableInsertUtils.addParensIfRequired(context, item, hasParams);
        FunctionInsertHandler.changeQualifyingTokenIfNeeded(context, this.myContextExpression, item);
        Editor editor = context.getEditor();
        if (hasParams) {
            AutoPopupController.getInstance(context.getProject()).autoPopupParameterInfo(editor, null);
        }
    }

    private static boolean isUsedAsAName(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement context) {
        if (context != null) {
            PsiElement parent = context.getParent();
            if (parent instanceof OCExpression) {
                PsiElement superParent = parent.getParent();
                if (superParent instanceof OCUnaryExpression) {
                    return ((OCUnaryExpression)superParent).isGetAddress();
                }
                Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes((OCExpression)parent, false);
                for (OCType type : types) {
                    OCFunctionType ft;
                    if (!((type = type.resolve(context.getContainingFile())) instanceof OCPointerType) || !(((OCPointerType)type).getRefType() instanceof OCFunctionType) || (ft = (OCFunctionType)((OCPointerType)type).getRefType()).checkCompatible(symbol.getResolvedType(), context).getState() != OCType.TypeCheckState.OK) continue;
                    return true;
                }
            } else if (parent instanceof OCCppUsingStatement) {
                return true;
            }
        }
        return false;
    }
}

