/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCLexingBlockCollector {
    List<Block> blocks = new ArrayList<Block>();
    List<Block> blockStack = new ArrayList<Block>();
    private int xorOffset = -1;
    private int parenBalance = 0;

    public void update(int offset, IElementType tt) {
        Block block;
        if (tt == OCTokenTypes.XOR) {
            this.xorOffset = offset;
            this.parenBalance = 0;
        } else if (tt == OCTokenTypes.SEMICOLON) {
            this.xorOffset = -1;
        } else if (tt == OCTokenTypes.LPAR && this.xorOffset >= 0) {
            ++this.parenBalance;
        } else if (tt == OCTokenTypes.RPAR && this.xorOffset >= 0) {
            --this.parenBalance;
        } else if (tt == OCTokenTypes.LBRACE) {
            if (this.xorOffset >= 0 && this.parenBalance == 0) {
                Block block2 = new Block(this.xorOffset, Integer.MAX_VALUE);
                this.blocks.add(block2);
                this.blockStack.add(block2);
            } else {
                Block block3 = (Block)ContainerUtil.getLastItem(this.blockStack);
                if (block3 != null) {
                    ++block3.braceBalance;
                }
            }
            this.xorOffset = -1;
        } else if (tt == OCTokenTypes.RBRACE && (block = (Block)ContainerUtil.getLastItem(this.blockStack)) != null && --block.braceBalance <= 0) {
            block.endOffset = offset + 1;
            this.blockStack.remove(this.blockStack.size() - 1);
        }
    }

    @Nullable
    public TextRange getLastCompleteBlockRange(int before) {
        Block result = null;
        int lastEnd = -1;
        for (Block block : this.blocks) {
            if (block.endOffset > before || block.endOffset <= lastEnd) continue;
            result = block;
            lastEnd = result.endOffset;
        }
        return result == null ? null : new TextRange(result.startOffset, result.endOffset);
    }

    private static class Block {
        private final int startOffset;
        private int endOffset;
        int braceBalance = 1;

        public Block(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

