/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.lexer.OCPrefixStringLiteralLexer;
import com.jetbrains.cidr.lang.lexer.OCRawStringLexerBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCEnterInStringHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiElement psiAtOffset = file2.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            Document document = editor.getDocument();
            String text = document.getText();
            ASTNode token = psiAtOffset.getNode();
            IElementType nodeType = token.getElementType();
            if (nodeType == OCTokenTypes.CHARACTER_LITERAL) {
                int pos = token.getStartOffset();
                caretOffsetRef.set((Object)pos);
                caretAdvanceRef.set((Object)(caretOffset - pos));
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
            if (OCTokenTypes.ALL_STRINGS.contains(nodeType)) {
                TextRange range = token.getTextRange();
                int stopChar = 34;
                OCPrefixStringLiteralLexer lexer = new OCPrefixStringLiteralLexer('\"', OCHighlightingLexer.PREFIX_TYPE, (LexerBase)(nodeType == OCTokenTypes.STRING_LITERAL ? OCHighlightingLexer.createStringLiteralLexer('\"', token.getElementType()) : new OCRawStringLexerBase(OCTokenTypes.STRING_LITERAL, OCTokenTypes.STRING_LITERAL)));
                lexer.start(text, range.getStartOffset(), range.getEndOffset());
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenStart() < caretOffset && caretOffset <= lexer.getTokenEnd()) {
                        IElementType tt = lexer.getTokenType();
                        if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tt)) {
                            caretOffset = lexer.getTokenEnd();
                            break;
                        }
                        if (tt == OCHighlightingLexer.PREFIX_TYPE) {
                            int pos = lexer.getTokenStart();
                            caretOffsetRef.set((Object)pos);
                            caretAdvanceRef.set((Object)(caretOffset - pos));
                            return EnterHandlerDelegate.Result.DefaultForceIndent;
                        }
                        if (tt != OCTokenTypes.STRING_LITERAL || nodeType != OCTokenTypes.RAW_STRING_LITERAL) break;
                        document.insertString(caretOffset, (CharSequence)"\n");
                        editor.getCaretModel().moveToOffset(caretOffset + 1);
                        return EnterHandlerDelegate.Result.Stop;
                    }
                    lexer.advance();
                }
                int lineEnd = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)caretOffset, (String)"\n");
                if (text.charAt(lineEnd = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineEnd - 1), (String)" \t")) == '\\') {
                    caretOffset = Math.min(caretOffset, lineEnd);
                    document.insertString(caretOffset, (CharSequence)"\\\n");
                    editor.getCaretModel().moveToOffset(caretOffset + 2);
                    return EnterHandlerDelegate.Result.Stop;
                }
                document.insertString(caretOffset, (CharSequence)"\"\"");
                caretAdvanceRef.set((Object)1);
                caretOffsetRef.set((Object)(caretOffset + 1));
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

