/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCCommenter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEnterInBlockCommentHandler
extends EnterHandlerDelegateAdapter {
    private static OCCommenter COMMENTER = new OCCommenter();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiElement psiAtOffset = file2.findElementAt(caretOffset == editor.getDocument().getTextLength() && caretOffset > 0 ? caretOffset - 1 : caretOffset);
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)caretOffset) instanceof OCLanguage && OCElementUtil.getElementType(psiAtOffset) == OCTokenTypes.BLOCK_COMMENT && psiAtOffset.getTextOffset() < caretOffset) {
            String commentText = psiAtOffset.getText();
            if (commentText.endsWith("*/") && !psiAtOffset.getTextRange().contains(caretOffset)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            int documentStartOffset = psiAtOffset.getTextRange().getStartOffset();
            int caretInStringOffset = caretOffset - documentStartOffset;
            String commentBeforeCaret = commentText.substring(0, caretInStringOffset);
            int commentLength = commentText.length();
            StringBuilder indent = new StringBuilder("\n");
            String indentFromContext = OCEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(psiAtOffset);
            if (indentFromContext == null) {
                indentFromContext = "";
            }
            indent.append(indentFromContext);
            if (((OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)editor.getProject()).getCustomSettings(OCCodeStyleSettings.class)).INDENT_BLOCK_COMMENT) {
                indent.append(' ');
            }
            StringBuilder initialIndent = new StringBuilder(indent);
            int insertCommentSuffixPosition = -1;
            if (commentBeforeCaret.indexOf(10) == -1) {
                indent.append("* ");
                if (OCEnterInBlockCommentHandler.needCommentSuffixGeneration(editor, (PsiComment)psiAtOffset, commentText)) {
                    int lineEnd = commentText.indexOf(10);
                    if (lineEnd == -1) {
                        lineEnd = commentText.length();
                    }
                    insertCommentSuffixPosition = caretOffset + indent.length() + (lineEnd - caretInStringOffset);
                }
            } else {
                int offsetInCommentString;
                char ch = ' ';
                StringBuilder prevIndent = new StringBuilder("\n");
                for (offsetInCommentString = commentBeforeCaret.lastIndexOf(10) + 1; offsetInCommentString < caretInStringOffset; ++offsetInCommentString) {
                    char c = commentText.charAt(offsetInCommentString);
                    ch = c;
                    if ("\t ".indexOf(c) < 0) break;
                    prevIndent.append(ch);
                }
                if (indent.length() < prevIndent.length()) {
                    indent = prevIndent;
                }
                if (ch == '*') {
                    int size;
                    indent.append('*');
                    if (++offsetInCommentString == caretInStringOffset && offsetInCommentString < commentLength) {
                        ch = commentText.charAt(offsetInCommentString);
                        if ("\t ".indexOf(ch) >= 0) {
                            ++caretOffset;
                            indent.append(ch);
                        }
                    } else {
                        while (offsetInCommentString < caretInStringOffset && "\t ".indexOf(ch = commentText.charAt(offsetInCommentString)) >= 0) {
                            ++offsetInCommentString;
                            indent.append(ch);
                        }
                    }
                    if ((size = indent.length()) != 0 && indent.charAt(size - 1) == '*') {
                        indent.append(' ');
                    }
                }
            }
            Document document = editor.getDocument();
            if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
                int deleteTo = caretInStringOffset;
                while (deleteTo < commentLength && "\t ".indexOf(commentText.charAt(deleteTo)) >= 0) {
                    ++deleteTo;
                    --insertCommentSuffixPosition;
                }
                document.deleteString(caretOffset, documentStartOffset + deleteTo);
            }
            document.insertString(caretOffset, (CharSequence)indent);
            editor.getCaretModel().moveToOffset(caretOffset + indent.length());
            if (insertCommentSuffixPosition >= 0) {
                StringBuilder insert = new StringBuilder().append((CharSequence)initialIndent).append("*/");
                document.insertString(insertCommentSuffixPosition, (CharSequence)insert);
            }
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean needCommentSuffixGeneration(@NotNull Editor editor, @NotNull PsiComment comment, @NotNull String commentText) {
        char ch;
        if (EnterHandler.isCommentComplete(comment, COMMENTER, editor)) {
            return false;
        }
        for (int offset = 0; offset < commentText.length() && (ch = commentText.charAt(offset)) != '\n'; ++offset) {
            if (!Character.isJavaIdentifierPart(ch) && "{}".indexOf(ch) < 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String getFirstCommentLineIndentFromContext(@NotNull PsiElement element) {
        String indentSpace = null;
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
        if (prev instanceof PsiWhiteSpace) {
            String whiteSpaces = prev.getText();
            int lineStart = whiteSpaces.lastIndexOf(10);
            if (lineStart >= 0) {
                indentSpace = whiteSpaces.substring(lineStart + 1);
            } else if (prev.getTextOffset() == 0) {
                indentSpace = whiteSpaces;
            }
        }
        return indentSpace;
    }
}

