/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCEnterAfterUnmatchedBraceHandler");

    @Override
    public boolean isApplicable(@NotNull PsiFile file2, int caretOffset) {
        return PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)caretOffset) instanceof OCLanguage && !DumbService.isDumb((Project)file2.getProject());
    }

    @Override
    @NotNull
    protected String generateStringToInsert(@NotNull Editor editor, int caretOffset, int maxRBraceCount) {
        assert (maxRBraceCount > 0);
        HighlighterIterator it = OCEnterAfterUnmatchedBraceHandler.createBeforeIterator((EditorEx)editor, caretOffset);
        int rBraceCount = 0;
        StringBuilder generatedRBraces = new StringBuilder(maxRBraceCount);
        while (((LexerEditorHighlighter.HighlighterIteratorImpl)it).currentIndex() >= 0 && rBraceCount < maxRBraceCount) {
            IElementType currType = it.getTokenType();
            if (currType == OCTokenTypes.LBRACE) {
                int pos = it.getStart();
                it.retreat();
                generatedRBraces.append('}');
                if (OCTypedHandlerDelegate.needSemicolonAtBlockEnd(it)) {
                    generatedRBraces.append(';');
                }
                it = OCEnterAfterUnmatchedBraceHandler.createBeforeIterator((EditorEx)editor, pos);
                ++rBraceCount;
                continue;
            }
            if (StringUtil.contains((CharSequence)it.getDocument().getCharsSequence(), (int)it.getStart(), (int)it.getEnd(), (char)'\n') || currType == OCTokenTypes.RBRACE) break;
            it.retreat();
        }
        return generatedRBraces.length() == 0 ? "}" : generatedRBraces.toString();
    }

    @NotNull
    private static HighlighterIterator createBeforeIterator(@NotNull EditorEx editor, int caretOffset) {
        return editor.getHighlighter().createIterator(caretOffset == 0 ? 0 : caretOffset - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void formatCodeFragmentBetweenBraces(@NotNull PsiFile file2, @NotNull Document document, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        Project project2 = file2.getProject();
        CommonCodeStyleSettings commonSettings = CodeStyleSettingsManager.getInstance((Project)project2).getCurrentSettings().getCommonSettings((Language)OCLanguage.getInstance());
        assert (commonSettings != null);
        int origKEEP_BLANK_LINES_BEFORE_RBRACE = commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE;
        commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 1;
        try {
            CodeStyleManager instance = CodeStyleManager.getInstance((Project)project2);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            instance.reformatText(file2, rBracesInsertOffset + 1, rBracesInsertOffset + generatedRBraces.length() + 2);
            instance.adjustLineIndent(file2, new TextRange(caretOffset, rBracesInsertOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            document.deleteString(caretOffset, caretOffset + 1);
            commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = origKEEP_BLANK_LINES_BEFORE_RBRACE;
        }
    }

    @Override
    protected Pair<PsiElement, Integer> calculateOffsetToInsertClosingBrace(@NotNull PsiFile file2, @NotNull CharSequence text, int offset) {
        Pair<PsiElement, Integer> pair = super.calculateOffsetToInsertClosingBrace(file2, text, offset);
        PsiElement element = (PsiElement)pair.first;
        int endOffset = (Integer)pair.second;
        if (OCElementUtil.getElementType(element) == OCElementTypes.MACRO_CALL) {
            ASTNode nextNode;
            PsiElement next = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)endOffset);
            for (nextNode = next.getNode(); nextNode != null && OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(nextNode)) && !(nextNode instanceof OCMacroForeignLeafElement); nextNode = nextNode.getTreeNext()) {
            }
            if (OCElementUtil.getElementType(nextNode) == OCTokenTypes.SEMICOLON && !(nextNode instanceof OCMacroForeignLeafElement)) {
                endOffset = nextNode.getTextRange().getEndOffset();
            }
        } else if (OCElementUtil.getElementType(element) == OCTokenTypes.RBRACE) {
            endOffset = element.getTextRange().getStartOffset();
        }
        return Pair.create((Object)element, (Object)endOffset);
    }
}

