/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;

public class LiteralJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(Document doc, PsiFile psiFile, int offsetNear, int end) {
        CharSequence text = doc.getCharsSequence();
        int start = offsetNear;
        while (text.charAt(start) == ' ' || text.charAt(start) == '\t') {
            --start;
        }
        if (text.charAt(start) == '\"') {
            --start;
        }
        if (start < offsetNear) {
            ++start;
        }
        boolean state = false;
        int startQuoteOffset = -1;
        block5: for (int j = start; j < doc.getTextLength(); ++j) {
            switch (text.charAt(j)) {
                case '\t': 
                case ' ': {
                    continue block5;
                }
                case '\"': {
                    if (!state) {
                        if (OCElementUtil.getElementType(psiFile.findElementAt(j)) != OCTokenTypes.STRING_LITERAL) {
                            return -1;
                        }
                        state = true;
                        startQuoteOffset = j;
                        continue block5;
                    }
                    if (!state) break block5;
                    doc.deleteString(startQuoteOffset, j + 1);
                    return startQuoteOffset;
                }
            }
        }
        return -1;
    }
}

