/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    @Nullable
    final ExternalProvider myExternalProvider;
    private Map<String, CodeStyleSettings> mySettings = new HashMap();

    public CidrDocumentationProvider() {
        this(null);
    }

    public CidrDocumentationProvider(@Nullable ExternalProvider provider) {
        this.myExternalProvider = provider;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        String content = this.quickDocContent(element, originalElement, false);
        return content != null ? CidrDocumentationProvider.wrapDocInHtml(content) : null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression && (result = CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element)) != null) {
            return result;
        }
        String doc = this.generateDocInnerHtml(element, originalElement, false);
        return doc == null ? null : CidrDocumentationProvider.wrapDocInHtml(doc);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (object instanceof OCSymbol) {
            return ((OCSymbol)object).locateDefinition();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        if (link == null || psiManager == null) {
            return null;
        }
        if (link.startsWith(PSI_LINK_PREFIX_METHOD)) {
            List parts = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",");
            if (parts.size() == 3) {
                PsiElement elementAt;
                PsiFile file2;
                String path = (String)parts.get(1);
                String offset = (String)parts.get(2);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file2 = psiManager.findFile(fileByPath)) != null && file2.isValid() && (elementAt = file2.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                    return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
                }
            }
        } else {
            int idx = link.lastIndexOf(35);
            if (idx > -1) {
                PsiFile file3;
                String path = link.substring(0, idx);
                String offset = link.substring(idx + 1);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file3 = psiManager.findFile(fileByPath)) != null && file3.isValid()) {
                    int off = Integer.parseInt(offset);
                    PsiElement elementAt = file3.findElementAt(off);
                    return TargetElementUtil.getInstance().getNamedElement(elementAt, off);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file2 = symbol.getContainingFile();
        if (file2 != null) {
            sb.append(',').append(file2.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @Nullable
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        PsiReference reference = sme.getReference();
        if (reference != null && reference instanceof OCPolyVariantReference) {
            List list = ((OCPolyVariantReference)reference).resolveToSymbols();
            StringBuilder builder = new StringBuilder("");
            for (Object o : list) {
                if (!(o instanceof OCMethodSymbol)) continue;
                OCMethodSymbol symbol = (OCMethodSymbol)o;
                OCClassSymbol parent = (OCClassSymbol)symbol.getParent();
                String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
                if (link == null) continue;
                builder.append("<a href=\"").append(link).append("\">").append(symbol.getSignature()).append(" (").append(parent.getPresentableName()).append(")</a><br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(), builder.toString()});
        }
        return null;
    }

    @Nullable
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCCppNamespace) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppNamespace)element).getSymbol();
            if (symbol instanceof OCNamespaceSymbol) {
                OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                if (namespaceSymbol.isInlineNamespace()) {
                    answer.append(OCTokenTypes.INLINE_KEYWORD.getName()).append(" ");
                }
                answer.append(symbol.getKindLowercase()).append(" ");
                String namespace = OCDocUtil.getNamespace(namespaceSymbol);
                if (!namespace.isEmpty()) {
                    answer.append(namespace).append("::");
                }
                return answer.append("<b>").append(symbol.getName()).append("</b>").toString();
            }
            return null;
        }
        if (element instanceof OCClassDeclaration) {
            OCFile file2;
            OCInterfaceSymbol anInterface;
            StringBuilder answer = new StringBuilder();
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type = cd.getType();
            if (type != null && (anInterface = type.getInterface()) != null && (file2 = anInterface.getContainingOCFile()) != null) {
                answer.append(CidrDocumentationProvider.declaredInHint(file2));
            }
            return answer.append(CidrDocumentationProvider.classHintDoc(cd)).toString();
        }
        if (element instanceof OCMethodSelectorPart) {
            StringBuilder answer = new StringBuilder();
            CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
            answer.append(" <b>");
            answer.append(((OCMethodSelectorPart)element).getName());
            answer.append("</b>");
            return answer.toString();
        }
        if (element instanceof OCTypeParameterDeclaration) {
            return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
        }
        if (element instanceof OCCategoryName) {
            OCCategoryName category = (OCCategoryName)element;
            PsiElement parent = category.getParent();
            if (parent instanceof OCClassDeclaration) {
                OCClassDeclaration cd = (OCClassDeclaration)parent;
                return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
            }
            return null;
        }
        if (element instanceof OCDeclarator) {
            String type;
            OCClassDeclaration container;
            PsiElement pp;
            OCFile containingFile;
            PsiReference reference;
            OCDeclarator declarator = (OCDeclarator)element;
            StringBuilder answer = new StringBuilder();
            OCSymbol symbol = null;
            PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
            if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
            }
            if (symbol == null) {
                symbol = declarator.getSymbol();
            }
            OCFile oCFile = containingFile = symbol == null ? null : symbol.getContainingOCFile();
            if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
                answer.append(CidrDocumentationProvider.declaredInHint(containingFile));
            }
            if (symbol != null) {
                CidrDocumentationProvider.addNamespace(symbol, answer);
                CidrDocumentationProvider.addVisibility(symbol, answer);
            }
            if ((pp = element.getParent().getParent()) instanceof OCProperty) {
                OCProperty property = (OCProperty)pp;
                String iVarDoc = this.propertyIVarDoc(property);
                if (iVarDoc != null) {
                    return iVarDoc;
                }
                OCClassDeclaration container2 = property.getContainingClass();
                if (container2 != null) {
                    answer.append(CidrDocumentationProvider.classHintDoc(container2)).append("<br>");
                }
                answer.append("@property ");
                OCPropertyAttributesList attrs = property.getPropertyAttributesList();
                if (attrs != null) {
                    String attrsStr = StringUtil.join(attrs.getAttributes(), (Function)new Function<OCPropertyAttribute, String>(){

                        public String fun(OCPropertyAttribute attribute) {
                            return attribute.getText();
                        }
                    }, (String)", ");
                    answer.append("(").append(attrsStr).append(") ");
                }
            } else if (pp instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
                answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
            }
            if (symbol != null) {
                if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                    answer.append("ivar ");
                } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                    answer.append("typedef ");
                }
            }
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol func = (OCFunctionSymbol)symbol;
                if (func.isFriendFunction()) {
                    OCFunctionSymbol definition = (OCFunctionSymbol)func.getDefinitionSymbol();
                    if (definition != null) {
                        func = definition;
                    }
                } else {
                    OCFunctionSymbol declaration = func.getDeclarationInParent();
                    if (declaration != null) {
                        func = declaration;
                    }
                }
                answer.append(CidrDocumentationProvider.getTemplateParameters(func));
                OCDocUtil.extractModifiers(func, answer);
                if (!func.isCppConstructor() && !func.isCppDestructor()) {
                    type = CidrDocumentationProvider.effectiveTypeString(func);
                    answer.append(type).append(OCDocUtil.delimiter(type));
                }
                answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(func));
                answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(func.getName())).append("</b>");
                this.extractFunctionSignature(declarator, func, answer);
            } else if (symbol instanceof OCDeclaratorSymbol) {
                answer.append(CidrDocumentationProvider.getTemplateParameters(symbol));
                OCDocUtil.extractModifiers((OCDeclaratorSymbol)symbol, answer);
                boolean isEnumConst = symbol.getKind() == OCSymbolKind.ENUM_CONST;
                type = CidrDocumentationProvider.effectiveTypeString(symbol);
                answer.append(type).append(OCDocUtil.delimiter(type, isEnumConst ? "::" : " "));
                if (!isEnumConst) {
                    answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(symbol));
                }
                answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            } else {
                CidrDocumentationProvider.appendType(answer, declarator.getRawType(), element.getContainingFile(), false);
                answer.append(" <b>");
                answer.append(declarator.getName());
                answer.append("</b>");
            }
            this.processInitializer(declarator, answer);
            return answer.toString();
        }
        if (element instanceof OCDefineDirective) {
            PsiFile file3 = element.getContainingFile();
            StringBuilder answer = new StringBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(file3));
            OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
            if (symbol == null) {
                return "";
            }
            answer.append("#define <b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            if (symbol.hasParameterList()) {
                answer.append('(');
                answer.append(StringUtil.join(symbol.getParameterNames(), (Function)new Function<String, String>(){

                    public String fun(String name) {
                        return CidrDocumentationProvider.escapeHTML(name);
                    }
                }, (String)", "));
                answer.append(')');
            }
            answer.append(" ").append(CidrDocumentationProvider.escapeHTML(symbol.getSubstitution()));
            return answer.toString();
        }
        if (element instanceof OCCppUsingStatement) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
            if (symbol instanceof OCAliasUsingSymbol) {
                answer.append("using <b>");
                answer.append(symbol.getName());
                answer.append("</b> = ");
                answer.append(CidrDocumentationProvider.effectiveTypeString(symbol));
            }
            return answer.toString();
        }
        if (element instanceof OCCppNamespaceAlias) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCCppNamespaceAlias namespaceAliasElement = (OCCppNamespaceAlias)element;
            OCNamespaceAliasSymbol symbol = (OCNamespaceAliasSymbol)namespaceAliasElement.getSymbol();
            if (OCLog.LOG.assertTrue(symbol != null)) {
                OCSymbolKind kind = symbol.getKind();
                OCSymbolReference ref = symbol.getNamespaceReference();
                answer.append(kind.getNameLowercase()).append(" ");
                answer.append("<b>").append(symbol.getName()).append("</b> = ");
                answer.append(ref.getQualifiedName().getCanonicalName(true));
            }
            return answer.toString();
        }
        if (element instanceof OCStructLike) {
            OCStructSymbol symbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            if (symbol == null) {
                return answer.toString();
            }
            CidrDocumentationProvider.addNamespace(symbol, answer);
            CidrDocumentationProvider.addVisibility(symbol, answer);
            String canonicalNamePrefix = CidrDocumentationProvider.getCanonicalNamePrefix(symbol);
            String templateParamList = CidrDocumentationProvider.getTemplateParameters(symbol);
            if (symbol.isPredeclaration()) {
                OCDocUtil.extractModifiers(symbol, answer);
            } else {
                answer.append(templateParamList);
            }
            answer.append(symbol.getKindLowercase()).append(" ");
            if (symbol.isEnumClass()) {
                answer.append("class ");
            }
            answer.append(canonicalNamePrefix).append("<b>").append(symbol.getName()).append("</b>");
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer);
            if (symbol.isFinal()) {
                answer.append(" ").append(OCTokenTypes.FINAL_CPP_KEYWORD.getName());
            }
            answer.append(CidrDocumentationProvider.getBaseClasses(symbol, element));
            return answer.toString().replaceAll("\\s+", " ");
        }
        OCFindUsagesProvider common = new OCFindUsagesProvider();
        if (common.canFindUsagesFor(element)) {
            return CidrDocumentationProvider.declaredInHint(element.getContainingFile()) + common.getType(element) + "  <b>" + common.getDescriptiveName(element) + "</b>";
        }
        return null;
    }

    @NotNull
    private static String getBaseClasses(@NotNull OCStructSymbol symbol, @NotNull PsiElement element) {
        OCResolveContext context = new OCResolveContext(element.getContext());
        Collection<Pair<OCType, OCVisibility>> baseClasses = symbol.getBaseCppClassesWithVisibility(context);
        if (!baseClasses.isEmpty()) {
            final List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
            final OCFile containingFile = symbol.getContainingOCFile();
            String baseClassesStr = StringUtil.join(baseClasses, (Function)new Function<Pair<OCType, OCVisibility>, String>(){

                public String fun(Pair<OCType, OCVisibility> pair) {
                    OCVisibility visibility = (OCVisibility)((Object)pair.getSecond());
                    String visibilityStr = "";
                    if (visibility != null) {
                        visibilityStr = (Object)((Object)visibility) + " ";
                    }
                    OCType type = (OCType)pair.getFirst();
                    return visibilityStr + OCDocUtil.getCanonicalName(type, contextNamespace, containingFile);
                }
            }, (String)", ");
            return " : " + baseClassesStr;
        }
        return "";
    }

    private void processInitializer(@NotNull OCDeclarator declarator, @NotNull StringBuilder answer) {
        OCExpression initializer = (declarator = this.cleanAndReformat(declarator, OCDeclarator.class)).getInitializer();
        if (initializer != null) {
            answer.append(" =");
        } else {
            initializer = declarator.getInitializerList();
        }
        if (initializer != null) {
            answer.append(" ");
            CidrDocumentationProvider.processExpressionElement(initializer, answer);
        } else {
            OCArgumentList args = declarator.getArgumentList();
            if (args != null) {
                CidrDocumentationProvider.processExpressionElement(args, answer);
            }
        }
    }

    private static void processExpressionElement(@NotNull OCElement initializer, @NotNull StringBuilder answer) {
        String text = initializer.getTextWithMacros();
        int idx = text.indexOf(10);
        if (idx != -1) {
            String part = text.substring(0, idx).replaceAll("\\s+", " ");
            answer.append(CidrDocumentationProvider.escapeHTML(part)).append("...");
        } else {
            answer.append(CidrDocumentationProvider.escapeHTML(text));
        }
    }

    private void extractFunctionSignature(OCDeclarator declarator, OCFunctionSymbol symbol, StringBuilder answer) {
        declarator = this.cleanAndReformat(declarator, OCDeclarator.class);
        OCTemplateArgumentList templateArgumentList = declarator.getTemplateArgumentList();
        Collection<OCTypeArgument> substitutionTypes = symbol.getSubstitution().getSubstitutedTypes();
        if (substitutionTypes != null && !substitutionTypes.isEmpty()) {
            answer.append(OCDocUtil.getParametersSignature(symbol, false));
        } else if (templateArgumentList != null && !templateArgumentList.isEmpty()) {
            String templateArgumentsStr = StringUtil.join(templateArgumentList.getArguments(), (Function)new Function<OCElement, String>(){

                public String fun(OCElement templateArgument) {
                    return templateArgument.getText();
                }
            }, (String)", ");
            answer.append(CidrDocumentationProvider.escapeHTML("<" + templateArgumentsStr + ">"));
            answer.append(OCDocUtil.getParametersSignature(symbol, true));
        } else {
            answer.append(OCDocUtil.getParametersSignature(symbol, true));
        }
        OCDocUtil.extractFuncPostModifiers(symbol, answer);
        OCNoexceptSpecifier noexcept = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)declarator, OCNoexceptSpecifier.class);
        if (noexcept != null) {
            CidrDocumentationProvider.processExpressionElement(noexcept, answer.append(" "));
        }
    }

    @NotNull
    private static String getTemplateParameters(@NotNull OCSymbol symbol) {
        if (symbol instanceof OCTemplateSymbol && symbol instanceof OCSymbolWithQualifiedName) {
            StringBuilder sb = new StringBuilder();
            OCTemplateSymbol templateSymbol = (OCTemplateSymbol)symbol;
            if (templateSymbol.isTemplateSymbol()) {
                List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)((Object)templateSymbol), OCSymbolKind.NAMESPACE);
                OCFile containingFile = symbol.getContainingOCFile();
                List<OCTypeParameterSymbol> templateParams = templateSymbol.getTemplateParameters();
                OCDocUtil.wrapTemplateParams(templateParams, contextNamespace, containingFile, sb);
                return sb.append("<br>").toString();
            }
        }
        return "";
    }

    @NotNull
    private <T extends PsiElement> T cleanAndReformat(@NotNull OCElement element, Class<T> clazz) {
        Language language;
        CodeFormatterFacade formatterFacade;
        PsiElement result;
        PsiElement copy = element.copy();
        final ArrayList comments = new ArrayList();
        copy.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(PsiComment comment) {
                comments.add(comment);
            }
        });
        for (PsiElement comment : comments) {
            comment.delete();
        }
        if (SourceTreeToPsiMap.hasTreeElement(copy) && (result = SourceTreeToPsiMap.treeElementToPsi((formatterFacade = new CodeFormatterFacade(this.getSettings(language = copy.getLanguage()), language)).processElement(SourceTreeToPsiMap.psiElementToTree(copy)))) != null) {
            return (T)result;
        }
        return (T)copy;
    }

    private CodeStyleSettings getSettings(Language lang) {
        String langID = lang.getID();
        if (!this.mySettings.containsKey(langID)) {
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.getCommonSettings((Language)lang).KEEP_LINE_BREAKS = true;
            settings.getCommonSettings((Language)lang).SPACE_WITHIN_BRACES = true;
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).DO_NOT_ADD_BREAKS = true;
            this.mySettings.put(langID, settings);
        }
        return this.mySettings.get(langID);
    }

    private static void extractTemplateSpecialization(@Nullable OCStructSymbol symbol, @NotNull StringBuilder sb) {
        List<OCTypeArgument> specialization;
        if (symbol != null && (specialization = symbol.getTemplateSpecialization()) != null && !specialization.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
            OCFile containingFile = symbol.getContainingOCFile();
            OCDocUtil.wrapTemplateArgs(specialization, contextNamespace, containingFile, sb);
        }
    }

    private static void addNamespace(@NotNull OCSymbol symbol, @NotNull StringBuilder answer) {
        String namespace;
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER && (namespace = OCDocUtil.getNamespace((OCSymbolWithQualifiedName)symbol)).length() > 0) {
            answer.append("namespace ").append(namespace).append("<br><br>");
        }
    }

    private static void addVisibility(@NotNull OCSymbol symbol, @NotNull StringBuilder answer) {
        OCVisibility visibility;
        if (symbol instanceof OCSymbolWithQualifiedName && (visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility()) != null && visibility != OCVisibility.NULL) {
            answer.append(visibility.toString()).append(":<br>");
        }
    }

    @NotNull
    private static String getCanonicalNamePrefix(@NotNull OCSymbol symbol) {
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER) {
            String prefix = OCDocUtil.getCanonicalPrefix((OCSymbolWithQualifiedName)symbol);
            return prefix.length() > 0 ? prefix + "::" : "";
        }
        return "";
    }

    @NotNull
    private static String effectiveTypeString(@NotNull OCSymbol symbol) {
        OCFile containingFile = symbol.getContainingOCFile();
        OCType type = symbol.getEffectiveType().accept(new OCTypeParameterResolveVisitor(containingFile));
        if (symbol instanceof OCSymbolWithQualifiedName) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)symbol, OCSymbolKind.NAMESPACE);
            return OCDocUtil.replaceAnonymous(OCDocUtil.getCanonicalName(type, contextNamespace, containingFile));
        }
        return OCDocUtil.replaceAnonymous(CidrDocumentationProvider.escapeHTML(type.getName(containingFile)));
    }

    @Nullable
    private String propertyIVarDoc(@NotNull OCProperty p) {
        PsiElement iVar = CidrDocumentationProvider.getPropertyIVar(p);
        if (iVar != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        if (ps != null) {
            iVar = ps.getAssociatedIvar();
        }
        return iVar == null ? null : (PsiElement)iVar.locateDefinition();
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        OCDeclaration pd = p.getDeclaration();
        if (pd == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.size() == 0) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    protected static String declaredInHint(@NotNull PsiFile file2) {
        return CidrDocumentationProvider.declaredInHint(file2.getName());
    }

    @NotNull
    public static String declaredInHint(@NotNull String fileName) {
        return "<b>Declared In:</b> " + fileName + "<br><br>";
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        if (element instanceof OCReferenceElement) {
            OCPropertySymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty();
                if (property2 != null) {
                    return property2.locateDefinition();
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getGeneratedFromProperty()) != null) {
                return property.locateDefinition();
            }
        }
        return element;
    }

    @Nullable
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type) {
        return type.getText();
    }

    @NotNull
    private static String classHintDoc(@NotNull OCClassDeclaration classDeclaration) {
        return (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
    }

    @NotNull
    private static String methodHintDoc(@NotNull OCMethod method) {
        StringBuilder answer = new StringBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        answer.append(method.isInstanceMethod() ? (char)'-' : '+').append(" ");
        CidrDocumentationProvider.appendType(answer, method.getRawReturnType(), method.getContainingFile(), true);
        for (OCMethodSelectorPart part : method.getParameters()) {
            String parameterName;
            answer.append("<b>");
            answer.append(part.getSelectorPart());
            answer.append("</b>");
            OCType type = part.getRawType();
            if (type != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type, method.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        return answer.toString();
    }

    private static void appendType(@NotNull StringBuilder answer, @NotNull OCType type, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        String typeText = type.accept(new OCTypeParameterResolveVisitor(context)).getName();
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(CidrDocumentationProvider.escapeHTML(typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    @Nullable
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        StringBuilder answer = new StringBuilder();
        if (this.myExternalProvider != null && element instanceof PsiNamedElement) {
            this.myExternalProvider.addExternalDoc(element, originalElement, answer);
        }
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (answer.length() == 0) {
            this.addCommentDoc(element, answer);
        }
        if (!skipQuickDoc && answer.length() == 0) {
            this.addQuickDoc(element, originalElement, answer);
        }
        if (element instanceof PsiNamedElement) {
            CidrDocumentationProvider.addManDoc(answer, (PsiNamedElement)element);
        }
        return answer.length() == 0 ? null : answer.toString();
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull StringBuilder answer) {
        String quickDoc = this.quickDocContent(element, originalElement, true);
        if (quickDoc != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            answer.append("<code>").append(quickDoc).append("</code>");
        }
    }

    private static void addManDoc(@NotNull StringBuilder answer, @NotNull PsiNamedElement namedElement) {
        VirtualFile vFile;
        PsiFile psiFile = namedElement.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (vFile == null || !vFile.getPath().contains("/usr/include/")) {
            return;
        }
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        String man = CidrDocumentationProvider.getManPage(name);
        if (man != null && man.length() > 0) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            if (answer.length() > 0) {
                answer.append("<br>");
            }
            answer.append(CidrDocumentationProvider.man2html(man));
        }
    }

    protected void addMacroDoc(@Nullable PsiElement originalElement, @NotNull StringBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file2;
        CidrDocumentationProvider.addBreakIfRequired(answer);
        if (answer.length() == 0 && (file2 = define.getContainingFile()) != null) {
            answer.append(CidrDocumentationProvider.declaredInHint(file2));
        }
        answer.append("<b>Definition:</b><br><br><tt><pre>");
        String defineText = this.cleanAndReformat(define, OCDefineDirective.class).getTextWithMacros().replaceAll("\\s+\\\\", "");
        answer.append(CidrDocumentationProvider.escapeHTML(defineText));
        answer.append("</pre></tt><br>");
        OCMacroCall call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)originalElement, (Class[])new Class[]{OCMacroCall.class});
        if (call != null) {
            answer.append("<b>Replacement:</b><br><br> <tt><pre>");
            answer.append(CidrDocumentationProvider.escapeHTML(call.getReplacementText()));
            answer.append("</pre></tt>");
        }
    }

    @NotNull
    protected static String escapeHTML(@NotNull String text) {
        return StringUtil.escapeXml((String)text);
    }

    private static void addBreakIfRequired(@NotNull StringBuilder answer) {
        if (answer.length() > 0) {
            answer.append("<hr/>");
        }
    }

    @Nullable
    private static String getManPage(@NotNull String name) {
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("man");
        cl.addParameter("3");
        cl.addParameter(name);
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            CapturingProcessHandler handler2 = new CapturingProcessHandler(cl);
            ProcessOutput result = handler2.runProcess(1000);
            if (result.isTimeout()) {
                return null;
            }
            return result.getStdout().trim();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static String man2html(@NotNull String man) {
        StringBuilder a = new StringBuilder();
        boolean wasBold = false;
        boolean wasUnderscored = false;
        for (int i = 0; i < man.length(); ++i) {
            boolean bold;
            char c = man.charAt(i);
            char next = i + 1 < man.length() ? man.charAt(i + 1) : (char)'\u0000';
            boolean underscored = c == '_' && next == '\b';
            boolean bl = bold = c != '_' && next == '\b';
            if (!bold && wasBold) {
                wasBold = false;
                a.append("</b>");
            }
            if (!underscored && wasUnderscored) {
                wasUnderscored = false;
                a.append("</u>");
            }
            if (c == '\n') {
                a.append("<br>\n");
                continue;
            }
            if (!bold && !underscored) {
                CidrDocumentationProvider.appendSymbol(a, c);
                continue;
            }
            if (bold && !wasBold) {
                a.append("<b>");
                wasBold = true;
            }
            if (underscored && !wasUnderscored) {
                a.append("<u>");
                wasUnderscored = true;
            }
            CidrDocumentationProvider.appendSymbol(a, man.charAt(i + 2));
            i += 2;
        }
        return a.toString();
    }

    private static void appendSymbol(@NotNull StringBuilder a, char c) {
        switch (c) {
            case ' ': {
                a.append("&nbsp;");
                break;
            }
            case '\t': {
                a.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                break;
            }
            case '<': {
                a.append("&lt;");
                break;
            }
            case '>': {
                a.append("&gt;");
                break;
            }
            case '\"': {
                a.append("&quot;");
                break;
            }
            default: {
                a.append(c);
            }
        }
    }

    @NotNull
    public static String wrapDocInHtml(@NotNull String doc) {
        return "<html><head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head><body>" + doc + "</body></html>";
    }

    @NotNull
    protected String prepareCommentText(@NotNull String text) {
        StringBuilder answer = new StringBuilder();
        text = CidrDocumentationProvider.entityTag(text, "@class", "Class", 3);
        text = CidrDocumentationProvider.entityTag(text, "@category", "Category", 3);
        text = CidrDocumentationProvider.entityTag(text, "@protocol", "Protocol", 3);
        text = CidrDocumentationProvider.entityTag(text, "@define", "Macro", 3);
        text = CidrDocumentationProvider.entityTag(text, "@defined", "Macro", 3);
        text = CidrDocumentationProvider.entityTag(text, "@function", "Function", 3);
        text = CidrDocumentationProvider.entityTag(text, "@enum", "Enumeration", 3);
        text = CidrDocumentationProvider.entityTag(text, "@file", "File", 3);
        text = CidrDocumentationProvider.entityTag(text, "@framework", "Framework", 3);
        text = CidrDocumentationProvider.entityTag(text, "@functiongroup", "Function Group", 3);
        text = CidrDocumentationProvider.entityTag(text, "@header", "Header", 3);
        text = CidrDocumentationProvider.entityTag(text, "@method", "Method", 3);
        text = CidrDocumentationProvider.entityTag(text, "@property", "Property", 3);
        text = CidrDocumentationProvider.entityTag(text, "@struct", "Struct", 3);
        text = CidrDocumentationProvider.entityTag(text, "@union", "Union", 3);
        text = CidrDocumentationProvider.entityTag(text, "@typedef", "Typedef", 3);
        text = CidrDocumentationProvider.entityTag(text, "@var", "Variable", 3);
        text = CidrDocumentationProvider.entityTag(text, "@const", "Constant", 0);
        text = CidrDocumentationProvider.entityTag(text, "@constant", "Constant", 0);
        text = CidrDocumentationProvider.entityTag(text, "@param", "Parameter", 0);
        text = CidrDocumentationProvider.entityTag(text, "@field", "Field", 0);
        text = CidrDocumentationProvider.headerTag(text, "@result", "Result", 0);
        text = CidrDocumentationProvider.entityTag(text, "@throws", "Throws", 0);
        text = CidrDocumentationProvider.headerTag(text, "@abstract", "Abstract", 4);
        text = CidrDocumentationProvider.headerTag(text, "@brief", "Brief", 4);
        text = CidrDocumentationProvider.headerTag(text, "@discussion", "Discussion", 4);
        for (String line : StringUtil.splitByLines((String)text)) {
            line = line.trim();
            line = StringUtil.trimStart((String)line, (String)"*");
            if ((line = line.trim()).isEmpty() && answer.length() > 0) {
                answer.append("<br>");
                continue;
            }
            answer.append(line).append(' ');
        }
        return answer.toString();
    }

    @NotNull
    private static String headerTag(@NotNull String text, @NotNull String tag, @NotNull String headerName, int level) {
        String replacement = level > 0 ? "<h" + level + ">" + headerName + "</h" + level + ">" : "<p>" + headerName;
        return text.replaceAll("\\s" + tag + "\\s", replacement);
    }

    @NotNull
    private static String entityTag(@NotNull String text, @NotNull String tag, @NotNull String kind, int level) {
        String replacement = kind + "&nbsp;<code>$1</code>&nbsp;";
        replacement = level > 0 ? "<h" + level + ">" + replacement + "</h" + level + ">" : "<p>" + replacement;
        return text.replaceAll("\\s" + tag + "\\s([\\w:\\(\\)\\+\\-:]*)\\s", replacement);
    }

    public void addCommentDoc(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        PsiComment comment = this.findCommentFor(element);
        if (comment != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
        }
        while (comment != null) {
            String text = this.stripCommentBegin(comment.getText());
            answer.insert(0, this.prepareCommentText(CidrDocumentationProvider.escapeHTML(text)) + "<br>");
            comment = this.findPrevCommentFor((PsiElement)comment);
        }
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if (text.startsWith("/*!") || text.startsWith("/**")) {
            text = text.substring(3);
        } else if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        text = StringUtil.trimEnd((String)text, (String)"*/");
        return text;
    }

    @Nullable
    protected PsiComment findCommentFor(@NotNull PsiElement element) {
        PsiComment comment = CidrDocumentationProvider.findOCCommentFor(element);
        if (comment == null && element instanceof OCSymbolDeclarator) {
            Object associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol();
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition()) != null) {
                comment = CidrDocumentationProvider.findOCCommentFor(associatedElement);
            }
        }
        return comment;
    }

    @Nullable
    protected PsiComment findPrevCommentFor(@NotNull PsiElement element) {
        PsiComment prevComment;
        PsiElement prevCommentPrecedingWS;
        PsiWhiteSpace w;
        PsiElement wPrev;
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiComment) {
            PsiComment comment = (PsiComment)prev;
            return this.acceptDocComment(comment) ? comment : null;
        }
        if (prev instanceof PsiWhiteSpace && (wPrev = (w = (PsiWhiteSpace)prev).getPrevSibling()) instanceof PsiComment && (prevCommentPrecedingWS = (prevComment = (PsiComment)wPrev).getPrevSibling()) instanceof PsiWhiteSpace && prevCommentPrecedingWS.getText().contains("\n")) {
            return this.acceptDocComment(prevComment) ? prevComment : null;
        }
        return null;
    }

    protected boolean acceptDocComment(@NotNull PsiComment comment) {
        return true;
    }

    @Nullable
    private static PsiComment findOCCommentFor(@Nullable PsiElement elt) {
        PsiElement child;
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt == null) {
            return null;
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return null;
        }
        for (PsiElement next = elt.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next instanceof PsiComment) {
                return (PsiComment)next;
            }
            if (next instanceof PsiWhiteSpace ? next.getText().contains("\n") : next.getNode().getElementType() != OCTokenTypes.SEMICOLON) break;
        }
        if ((child = elt.getFirstChild()) instanceof PsiComment) {
            return (PsiComment)child;
        }
        for (elt = elt.getPrevSibling(); elt != null; elt = elt.getPrevSibling()) {
            PsiElement precedingWS;
            if (elt instanceof PsiComment && ((precedingWS = elt.getPrevSibling()) == null || precedingWS instanceof PsiWhiteSpace && precedingWS.getText().contains("\n"))) {
                return (PsiComment)elt;
            }
            if (elt.getTextLength() <= 0) continue;
            IElementType type = OCElementUtil.getObjCKeywordElementType(elt.getNode());
            if (!(elt instanceof PsiWhiteSpace) && type != OCTokenTypes.OPTIONAL_KEYWORD && type != OCTokenTypes.REQUIRED_KEYWORD) break;
        }
        return null;
    }

    public static interface ExternalProvider {
        public void addExternalDoc(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull StringBuilder var3);
    }
}

