/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNotUsedValueChecker;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAUtils {
    @Contract(value="null->false")
    public static boolean isConstant(@Nullable OCExpression expression) {
        return OCExpressionEvaluator.evaluate(expression) != null;
    }

    @Contract(value="null -> false")
    public static boolean isNewExpression(@Nullable OCExpression rValue) {
        return rValue instanceof OCCppNewExpression;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLocalVariable(@Nullable OCSymbol symbol, OCControlFlowGraph graph) {
        return symbol != null && graph.getLocalSymbols().contains(symbol) && (!(symbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)symbol).isStatic());
    }

    @Contract(value="null -> null")
    @Nullable
    public static OCSymbol getCallSymbol(@Nullable PsiElement expression) {
        OCSymbol<PsiElement> symbol = null;
        if (expression instanceof OCCallExpression) {
            OCExpression receiver = ((OCCallExpression)expression).getFunctionReferenceExpression();
            if (receiver instanceof OCReferenceExpression) {
                symbol = ((OCReferenceExpression)receiver).resolveToSymbol();
            } else if (receiver instanceof OCQualifiedExpression) {
                symbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
            }
        } else if (expression instanceof OCSendMessageExpression) {
            symbol = ((OCSendMessageExpression)expression).getProbableResponders().getKnownResponder();
        }
        return expression != null && OCDFAUtils.isGoodCallable(expression.getContainingFile(), symbol) ? symbol : null;
    }

    @Contract(value="_, null -> false")
    public static boolean isGoodCallable(@NotNull PsiFile file2, @Nullable OCSymbol symbol) {
        return symbol != null && symbol.isCallable() && file2.getVirtualFile() != null && file2.getVirtualFile().equals(symbol.getContainingFile());
    }

    public static boolean isPrivateCallable(OCSymbol symbol) {
        Object element = symbol.locateDefinition();
        final PsiFile file2 = element != null ? element.getContainingFile() : null;
        return file2 != null && ReferencesSearch.search(element).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                return reference.getElement().getContainingFile().equals(file2);
            }
        });
    }

    public static boolean processTypeHierarchy(@NotNull OCType type, final @NotNull PsiElement context, final @NotNull Set<OCType> processed2, final @NotNull Processor<Pair<OCType, OCType>> processor2) {
        ProgressManager.checkCanceled();
        final OCType resolvedType = type.resolve(context.getContainingFile());
        if (processed2.contains(resolvedType)) {
            return true;
        }
        processed2.add(resolvedType);
        OCType counterpart = OCTollFreeBridges.getCounterpart(type, context.getContainingFile());
        if (counterpart != null) {
            processor2.process((Object)Pair.create((Object)resolvedType, (Object)counterpart));
            processor2.process((Object)Pair.create((Object)counterpart, (Object)resolvedType));
        }
        if (resolvedType.isPointerToObject() && !resolvedType.isPointerToID() && !resolvedType.getName().equals("NSData *") && !resolvedType.getName().equals("NSNull *")) {
            OCType superType = ((OCObjectType)resolvedType.getTerminalType()).getSuperType();
            if (superType != null) {
                superType = OCPointerType.to(superType);
                processor2.process((Object)Pair.create((Object)resolvedType, (Object)superType));
                OCDFAUtils.processTypeHierarchy(superType, context, processed2, processor2);
            } else {
                processor2.process((Object)new Pair((Object)resolvedType, null));
            }
            return true;
        }
        if (resolvedType.isCppStructType() || resolvedType.isPointerToCppStructType()) {
            OCType terminalType = resolvedType.getTerminalType();
            if (!(terminalType instanceof OCStructType)) {
                return false;
            }
            ((OCStructType)terminalType).getSymbol().processAllBaseClasses(new OCStructSymbol.BaseClassProcessor(){

                @Override
                public boolean process(OCSymbol symbol, OCVisibility visibility) {
                    if (symbol instanceof OCStructSymbol) {
                        OCType superType = resolvedType.isPointer() ? OCPointerType.to(symbol.getType()) : symbol.getType();
                        processor2.process((Object)Pair.create((Object)resolvedType, (Object)superType));
                        OCDFAUtils.processTypeHierarchy(superType, context, processed2, (Processor<Pair<OCType, OCType>>)processor2);
                    }
                    return true;
                }
            });
            return true;
        }
        return false;
    }

    @Nullable
    public static InstanceOf getInstanceofPair(@Nullable OCExpression expression) {
        OCSendMessageExpression messageExpr;
        OCExpression receiver;
        if (expression instanceof OCSendMessageExpression && (receiver = (messageExpr = (OCSendMessageExpression)expression).getReceiverExpression()) instanceof OCReferenceExpression && messageExpr.getMessageSelector().equals("isKindOfClass:")) {
            OCReferenceElement receiverElement = ((OCReferenceExpression)receiver).getReferenceElement();
            OCExpression typeExpr = messageExpr.getArgumentExpressions().get(0);
            if (typeExpr instanceof OCSendMessageExpression && receiverElement != null) {
                OCSymbol symbol;
                OCReferenceElement typeElement;
                OCSendMessageExpression typeMessageExpr = (OCSendMessageExpression)typeExpr;
                OCExpression typeReceiver = typeMessageExpr.getReceiverExpression();
                if (typeMessageExpr.getMessageSelector().equals("class") && typeReceiver instanceof OCReferenceExpression && (typeElement = ((OCReferenceExpression)typeReceiver).getReferenceElement()) != null && (symbol = receiverElement.resolveToSymbol()) != null) {
                    return new InstanceOf((OCReferenceExpression)receiver, symbol, OCPointerType.to(OCReferenceType.resolvedFromText(typeElement.getName(), expression.getContainingFile())));
                }
            }
        }
        return null;
    }

    @NotNull
    public static Pair<Set<PsiElement>, OCControlFlowGraph> getNotUsedWrites(@NotNull OCCallable callable) {
        OCControlFlowGraph graph = new OCControlFlowGraph(callable, null);
        OCControlFlowBuilder builder = new OCControlFlowBuilder(null, graph, null);
        builder.processFirstCodeFragment(callable);
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        for (OCSymbol symbol : graph.getLocalSymbols()) {
            OCNotUsedValueChecker notUsedChecker = new OCNotUsedValueChecker(graph, symbol){

                @Override
                protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
                    PsiElement element = instruction.getRValue();
                    if (element instanceof OCReferenceExpression && this.isGoodParent(element)) {
                        return super.isStartInstruction(instruction);
                    }
                    return false;
                }

                @Override
                protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
                    return true;
                }

                @Override
                protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
                    return instruction.getRValue();
                }

                private boolean isGoodParent(PsiElement element) {
                    OCElementType sign;
                    PsiElement parent = element.getParent();
                    if (parent instanceof OCCastExpression) {
                        return true;
                    }
                    if (parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getSourceExpression() == element) {
                        return true;
                    }
                    if (parent instanceof OCIfStatement && ((OCIfStatement)parent).getCondition() == element) {
                        return true;
                    }
                    if (parent instanceof OCSwitchStatement && ((OCSwitchStatement)parent).getExpression() == element) {
                        return true;
                    }
                    if (parent instanceof OCDeclarationOrExpression || parent instanceof OCExpression && OCDFAUtils.getInstanceofPair((OCExpression)parent) != null) {
                        return this.isGoodParent(parent);
                    }
                    if (parent instanceof OCSendMessageExpression || parent instanceof OCQualifiedExpression || parent instanceof OCArraySelectionExpression) {
                        return true;
                    }
                    if (parent instanceof OCUnaryExpression) {
                        OCElementType sign2 = ((OCUnaryExpression)parent).getOperationSign();
                        if (sign2 == OCTokenTypes.MUL) {
                            return true;
                        }
                        if (sign2 == OCTokenTypes.EXCL) {
                            return this.isGoodParent(parent);
                        }
                    } else if (parent instanceof OCBinaryExpression && ((sign = ((OCBinaryExpression)parent).getOperationSign()) == OCTokenTypes.EQEQ || sign == OCTokenTypes.EXCLEQ || sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR)) {
                        return this.isGoodParent(parent);
                    }
                    return false;
                }
            };
            notUsedChecker.process();
            result.addAll(notUsedChecker.getNotUsedWrites());
        }
        return Pair.create(result, (Object)graph);
    }

    public static boolean areValuesUsed(@NotNull List<PsiElement> values, @NotNull Set<PsiElement> notUsedValues) {
        for (PsiElement value : values) {
            if (notUsedValues.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGotos(@NotNull OCCallable callable) {
        final Ref hasGoto = Ref.create((Object)false);
        callable.accept(new OCRecursiveVisitor(){

            @Override
            public void visitGotoStatement(OCGotoStatement stmt) {
                hasGoto.set((Object)true);
            }
        });
        return (Boolean)hasGoto.get();
    }

    public static class WorkingTimeMeasurer {
        private static final int CHECK_EVERY = 1000;
        private final long myTimeLimit;
        private final long myStart;
        private long myCounter;

        public WorkingTimeMeasurer(long nanoLimit) {
            this.myTimeLimit = nanoLimit;
            this.myStart = System.nanoTime();
        }

        public boolean isTimeOver() {
            if (this.myCounter++ == 1000L) {
                this.myCounter = 0L;
                return System.nanoTime() - this.myStart > this.myTimeLimit;
            }
            return false;
        }
    }

    public static class InstanceOf {
        OCReferenceExpression variable;
        OCSymbol symbol;
        OCType type;

        public InstanceOf(OCReferenceExpression variable, OCSymbol symbol, OCType type) {
            this.variable = variable;
            this.symbol = symbol;
            this.type = type;
        }
    }

    public static class DFAException
    extends RuntimeException {
        public DFAException(String message) {
            super(message);
        }
    }
}

