/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCNotInitializedVarChecker
extends OCSingleSymbolAlgorithm {
    private boolean myWasInitialized;

    protected OCNotInitializedVarChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        super(cfg, true, symbol);
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        OCControlFlowGraph parentCfg = this.myCfg.getClosureVariableDeclaratorGraph(this.mySymbol);
        if (parentCfg != null) {
            if (this.myCfg.hasInstructionsInParentGraph(this.mySymbol, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE)) {
                this.myWasInitialized = true;
                return;
            }
            if (parentCfg.getInstructions(this.mySymbol) != null) {
                this.traverseFromStart(this.mySymbol);
            }
        } else {
            this.traverse(this.myCfg.getDeclaratorInstruction(this.mySymbol), this.mySymbol, true);
        }
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        switch (instruction.getKind()) {
            case KILL: 
            case WRITE: 
            case WRITE_IN_BLOCK: 
            case REFERENCE: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        return instruction.getKind() == OCInstruction.InstructionKind.DECLARATOR;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        return instruction.getKind() == OCInstruction.InstructionKind.READ && !instruction.isTransparentRead();
    }

    @Override
    @Nullable
    protected List<OCNode> getJumpTargets(@NotNull OCNode node, boolean isForward) {
        List<OCNode> jumpTargets = super.getJumpTargets(node, isForward);
        List<OCNode> fakeJumpTargets = node.getFakeJumpTargets();
        if (jumpTargets != null && fakeJumpTargets != null) {
            ArrayList<OCNode> result = new ArrayList<OCNode>(jumpTargets);
            result.removeAll(fakeJumpTargets);
            return result;
        }
        return jumpTargets;
    }

    @NotNull
    public List<PsiElement> getNotInitializedReads() {
        if (this.myWasInitialized) {
            return Collections.emptyList();
        }
        return this.getReachableElements();
    }
}

