/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCMultiSymbolAlgorithm;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCEscapedValuesChecker
extends OCMultiSymbolAlgorithm {
    OCEscapedValuesChecker(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    protected boolean processClosureSymbols() {
        return false;
    }

    @NotNull
    public List<PsiElement> getEscapedVariables() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (Pair<OCSymbol, PsiElement> pair : this.getReachableElements()) {
            result.add((PsiElement)pair.getSecond());
        }
        return result;
    }

    @Override
    protected boolean isGoodWrite(@Nullable PsiElement element) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpr = (OCUnaryExpression)element;
            if (unaryExpr.isGetAddress()) {
                return OCEscapedValuesChecker.isLocalVar(unaryExpr.getOperand());
            }
        } else if (element instanceof OCBlockExpression) {
            return !OCCompilerHelper.isArcEnabled(element.getContainingFile());
        }
        return false;
    }

    private static boolean isLocalVar(OCExpression operand) {
        if (operand != null) {
            while (operand instanceof OCQualifiedExpression && ((OCQualifiedExpression)operand).getQualifyingTokenKind() == OCTokenTypes.DOT) {
                operand = ((OCQualifiedExpression)operand).getQualifier();
            }
            OCLValueVisitor visitor = new OCLValueVisitor();
            operand.accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (!(symbol == null || visitor.getNumOfDereferences() != 0 || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic())) {
                if (symbol.getType() instanceof OCCppReferenceType) {
                    Object declarator = symbol.locateDefinition();
                    return OCEscapedValuesChecker.isLocalVar(declarator != null ? ((OCDeclarator)declarator).getInitializer() : null);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean treatReferencesAsStartInstructions() {
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        return super.isEndInstruction(instruction) && OCEscapedValuesChecker.isEscaped(instruction.getRValue(), null);
    }

    @NotNull
    public List<PsiElement> getEscapedObjects() {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        final PsiElement codeFragment = this.myCfg.getCodeFragment();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                OCElement blockScope;
                if (blockExpression != codeFragment && OCEscapedValuesChecker.this.isGoodWrite(blockExpression) && (blockScope = (OCElement)ContainerUtil.getFirstItem((List)((List)OCCodeInsightUtil.getScopeAndKind(blockExpression).getFirst()))) != null && OCEscapedValuesChecker.isEscaped(blockExpression, blockScope.getTextRange())) {
                    result.add(blockExpression);
                }
            }

            @Override
            public void visitReferenceExpression(OCReferenceExpression expression) {
                OCSymbol symbol = expression.resolveToSymbol();
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE && symbol.getResolvedType() instanceof OCArrayType && !((OCDeclaratorSymbol)symbol).isStatic() && OCEscapedValuesChecker.isEscaped(expression, null)) {
                    result.add(expression);
                }
            }

            @Override
            public void visitUnaryExpression(OCUnaryExpression expression) {
                super.visitUnaryExpression(expression);
                if (OCEscapedValuesChecker.this.isGoodWrite(expression) && OCEscapedValuesChecker.isEscaped(expression, null)) {
                    result.add(expression);
                }
            }
        });
        return result;
    }

    private static boolean isEscaped(@Nullable PsiElement element, @Nullable TextRange scope) {
        OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCCallExpression.class, OCSendMessageExpression.class, OCAssignmentExpression.class, OCStatement.class, OCMacroCallArgument.class, OCTypeElement.class, OCBinaryExpression.class, OCUnaryExpression.class, OCQualifiedExpression.class, OCArraySelectionExpression.class});
        if (parent instanceof OCAssignmentExpression) {
            OCLValueVisitor visitor = new OCLValueVisitor();
            ((OCAssignmentExpression)parent).getReceiverExpression().accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (symbol != null) {
                if (symbol instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                    return false;
                }
                if (scope != null && !scope.equals((Object)symbol.getScope())) {
                    return true;
                }
                if (scope == null && !symbol.getKind().isLocal()) {
                    return true;
                }
            }
        } else if (parent instanceof OCReturnStatement) {
            return true;
        }
        return false;
    }
}

