/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCProblemGroup
implements SuppressableProblemGroup {
    @Nullable
    private final String myProblemName;
    @Nullable
    private OCSuppressionGroup mySuppressGroup;
    private List<SuppressIntentionAction> mySuppressActions;

    public OCProblemGroup(@Nullable String problemName) {
        this.myProblemName = problemName;
    }

    public OCProblemGroup(@Nullable String problemName, @Nullable OCSuppressionGroup suppressionGroup, @Nullable OCFile file2, @NotNull TextRange range) {
        this.myProblemName = problemName;
        this.mySuppressGroup = suppressionGroup;
        this.mySuppressActions = new ArrayList<OCSuppressClangDiagnosticIntentionAction>(Arrays.asList(new OCSuppressClangDiagnosticIntentionAction[]{new OCSuppressClangDiagnosticIntentionAction.ForStatement(file2, range, suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.ForCallable(file2, range, suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.ForFile(file2, range, suppressionGroup)}));
    }

    @Nullable
    public String getProblemName() {
        return this.myProblemName;
    }

    @Nullable
    public String getSuppressOption() {
        return this.mySuppressGroup == null ? null : this.mySuppressGroup.suppressionOption;
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        if (this.mySuppressActions != null) {
            return this.mySuppressActions.toArray(new SuppressIntentionAction[this.mySuppressActions.size()]);
        }
        return new SuppressIntentionAction[0];
    }

    public void addSuppressAction(@NotNull SuppressIntentionAction action) {
        if (this.mySuppressActions != null) {
            this.mySuppressActions.add(action);
        } else {
            this.mySuppressActions = new ArrayList<SuppressIntentionAction>(Arrays.asList(action));
        }
    }
}

