/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCLargeFileHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    private static final String LANGUAGES_STRING = PlatformUtils.isAppCode() ? "C/Objective-C/C++" : "C/C++";
    private final PsiFile myFile;
    @NotNull
    private Collection<HighlightInfo> myHighlightInfos = Collections.emptyList();

    public OCLargeFileHighlighter(PsiFile file2, Document document) {
        super(file2.getProject(), document);
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHighlightInfos = Collections.emptyList();
        int textLength = this.myFile.getTextLength();
        if (OCCodeInsightUtil.isCodeInsightAvailable(textLength)) {
            return;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        TextRange range = this.myFile.getTextRange();
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(range).fileLevelAnnotation().description("File length (" + textLength + ") " + "exceeds configured limit for " + LANGUAGES_STRING + " (" + OCCodeInsightUtil.getMaxFileLength() + "). " + "Code insight features are not available.").create();
        if (info == null) {
            return;
        }
        IntentionAction fix = new IntentionAction(){

            @Nls
            @NotNull
            public String getText() {
                return "Change the maximum file length";
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                return LANGUAGES_STRING;
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                return true;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
                OCLargeFileHighlighter.this.adjustMaxFileSize();
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        info.registerFix(fix, Collections.emptyList(), "Change the maximum file length", range, null);
        infos.add(info);
        this.myHighlightInfos = infos;
    }

    private void adjustMaxFileSize() {
        String result;
        int newValue;
        int initialValue = OCCodeInsightUtil.getMaxFileLength();
        if (initialValue == (newValue = StringUtil.parseInt((String)(result = Messages.showInputDialog((Project)this.myProject, (String)("Enter the new maximum length for " + LANGUAGES_STRING + " files in characters"), (String)"Maximum File Length", null, (String)String.valueOf(initialValue), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return StringUtil.parseInt((String)inputString, (int)-1) > 0;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })), (int)initialValue))) {
            return;
        }
        OCCodeInsightUtil.setMaxFileLength(newValue);
        this.applyToEditor(Collections.emptyList());
        OCSymbolTablesBuildingActivity activity = OCSymbolTablesBuildingActivity.getInstance(this.myProject);
        if (activity != null) {
            activity.rebuildSymbols(false);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        this.applyToEditor(this.myHighlightInfos);
    }

    private void applyToEditor(@NotNull Collection<HighlightInfo> infos) {
        if (this.myDocument != null) {
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myDocument.getTextLength(), infos, this.getColorsScheme(), this.getId());
        }
    }
}

